/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.reflect.classes.TestClass01;
import org.conqat.lib.commons.reflect.classes.TestClass02;
import org.conqat.lib.commons.reflect.classes.TestClass03;
import org.conqat.lib.commons.reflect.classes.TestClass04;
import org.conqat.lib.commons.reflect.classes.TestClass05;
import org.conqat.lib.commons.reflect.classes.TestClass06;
import org.conqat.lib.commons.reflect.classes.TestClass09;
import org.conqat.lib.commons.reflect.classes.TestClass10;

public class ReflectionUtilsMethodReturnTypeTest
extends TestCase {
    private static final String METHOD_NAME = "process";

    public void testSimple() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass01.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(Object.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass01.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(Object.class, actual);
    }

    public void testInheritedMethod() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass02.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(List.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass02.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(List.class, actual);
    }

    public void testInheritedMethodWithCovariantReturnType() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass03.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(ArrayList.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass03.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(ArrayList.class, actual);
    }

    public void testInheritedMethodWithGenericReturnType() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass04.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(Collection.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass04.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(List.class, actual);
    }

    public void testInheritedMethodWithGenericCovariantReturnType() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass05.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(ArrayList.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass05.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(ArrayList.class, actual);
    }

    public void testSimpleWithCovariance() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass06.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(String.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass06.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(String.class, actual);
    }

    public void testInheritedMethodWithParameterizedGenericReturnType() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass09.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(Collection.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass09.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(List.class, actual);
    }

    public void testGenericMethodWithMultipleParameters() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(TestClass10.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(Collection.class, actual);
        actual = ReflectionUtils.obtainGenericMethodReturnType(TestClass10.class, METHOD_NAME);
        ReflectionUtilsMethodReturnTypeTest.assertEquals(List.class, actual);
    }

    public void testMethodNotFound() {
        try {
            ReflectionUtils.obtainMethodReturnType(TestClass05.class, "unknown");
        }
        catch (NoSuchMethodException e) {
            return;
        }
        ReflectionUtilsMethodReturnTypeTest.fail((String)"should raise an exception");
    }
}

