/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import junit.framework.TestCase;
import org.conqat.lib.commons.assertion.PreconditionException;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class LineOffsetConverterTest
extends TestCase {
    public void testSingleLine() {
        String s = "abcdef";
        LineOffsetConverter converter = new LineOffsetConverter(s);
        int i = 0;
        while (i < s.length()) {
            LineOffsetConverterTest.assertEquals((String)("Error for character " + i), (int)1, (int)converter.getLine(i));
            ++i;
        }
        LineOffsetConverterTest.assertEquals((int)0, (int)converter.getOffset(1));
    }

    public void testEmpty() {
        LineOffsetConverter converter = new LineOffsetConverter("");
        LineOffsetConverterTest.assertEquals((int)1, (int)converter.getLine(0));
        LineOffsetConverterTest.assertEquals((int)0, (int)converter.getOffset(1));
    }

    public void testMultiLine() {
        String s = "012\n4567\n\nX";
        LineOffsetConverter converter = new LineOffsetConverter(s);
        int i = 0;
        while (i < 4) {
            LineOffsetConverterTest.assertEquals((String)("Error for character " + i), (int)1, (int)converter.getLine(i));
            ++i;
        }
        i = 4;
        while (i < 9) {
            LineOffsetConverterTest.assertEquals((String)("Error for character " + i), (int)2, (int)converter.getLine(i));
            ++i;
        }
        LineOffsetConverterTest.assertEquals((int)3, (int)converter.getLine(9));
        LineOffsetConverterTest.assertEquals((int)4, (int)converter.getLine(10));
        LineOffsetConverterTest.assertEquals((int)4, (int)converter.getLine(11));
        LineOffsetConverterTest.assertEquals((int)0, (int)converter.getOffset(1));
        LineOffsetConverterTest.assertEquals((int)4, (int)converter.getOffset(2));
        LineOffsetConverterTest.assertEquals((int)9, (int)converter.getOffset(3));
        LineOffsetConverterTest.assertEquals((int)10, (int)converter.getOffset(4));
    }

    public void testErrorHandling() {
        try {
            new LineOffsetConverter("abc\n\rdef");
            LineOffsetConverterTest.fail((String)"Expected exception!");
        }
        catch (PreconditionException preconditionException) {
            // empty catch block
        }
    }
}

