/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import junit.framework.TestCase;
import org.conqat.lib.commons.string.LineSplitter;
import org.conqat.lib.commons.string.StringUtils;

public class LineSplitterTest
extends TestCase {
    private final LineSplitter splitter = new LineSplitter();

    public void testUninitializedContent() {
        LineSplitterTest.assertNull((Object)this.splitter.getNextLine());
    }

    public void testNullContent() {
        this.splitter.setContent(null);
        LineSplitterTest.assertNull((Object)this.splitter.getNextLine());
    }

    public void testEmptyContent() {
        this.splitter.setContent("");
        LineSplitterTest.assertNull((Object)this.splitter.getNextLine());
    }

    public void testOneLineContent() {
        this.splitter.setContent("test");
        LineSplitterTest.assertEquals((String)"test", (String)this.splitter.getNextLine());
        LineSplitterTest.assertNull((Object)this.splitter.getNextLine());
    }

    public void testMultiLineContentN() {
        this.test("\n");
    }

    public void testMultiLineContentRN() {
        this.test("\r\n");
    }

    public void testMultiLineContentR() {
        this.test("\r");
    }

    public void testMultiLineContentNative() {
        this.test(System.getProperty("line.separator"));
    }

    private void test(String lineTerminator) {
        Object[] array = StringUtils.randomStringArray(100, 80);
        String test = StringUtils.concat(array, lineTerminator);
        this.splitter.setContent(test);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object expected = objectArray[n2];
            LineSplitterTest.assertEquals((String)expected, (String)this.splitter.getNextLine());
            ++n2;
        }
        LineSplitterTest.assertNull((Object)this.splitter.getNextLine());
    }
}

