/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import junit.framework.TestCase;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.string.UndoStack;

public class StringUndoStackBaseTest
extends TestCase {
    private UndoStack stack;

    public void testInit() {
        this.stack = new UndoStack("Test");
        this.checkStackState(false, false, "Test", 0);
    }

    public void testInitEmpty() {
        this.stack = new UndoStack("");
        this.checkStackState(false, false, "", 0);
    }

    public void testAdd() {
        this.testInit();
        this.stack.addLine("Test2");
        this.checkStackState(true, false, "Test" + StringUtils.CR + "Test2", 1);
    }

    public void testUndo() {
        this.testAdd();
        this.stack.undo();
        this.checkStackState(false, true, "Test", 2);
    }

    public void testRedo() {
        this.testUndo();
        this.stack.redo();
        this.checkStackState(true, false, "Test" + StringUtils.CR + "Test2", 3);
    }

    public void testMultipleOperations() {
        int n = 100;
        String[] lines = StringUtils.generateStringArray(n, 100, 1);
        this.stack = new UndoStack("");
        int i = 0;
        while (i < n) {
            this.stack.addLine(lines[i]);
            this.checkStackState(true, false, StringUndoStackBaseTest.concat(lines, i + 1), i + 1);
            ++i;
        }
        i = lines.length;
        while (i > 0) {
            this.stack.undo();
            this.checkStackState(i > 1, true, StringUndoStackBaseTest.concat(lines, i - 1), 2 * n - i + 1);
            --i;
        }
        i = 0;
        while (i < lines.length) {
            this.stack.redo();
            this.checkStackState(true, i < n - 1, StringUndoStackBaseTest.concat(lines, i + 1), n * 2 + i + 1);
            ++i;
        }
    }

    private static String concat(String[] lines, int i) {
        Object[] result = new String[i];
        System.arraycopy(lines, 0, result, 0, i);
        return StringUtils.concat(result, StringUtils.CR);
    }

    private void checkStackState(boolean canUndo, boolean canRedo, String model, int changeCount) {
        StringUndoStackBaseTest.assertEquals((boolean)canUndo, (boolean)this.stack.canUndo());
        StringUndoStackBaseTest.assertEquals((boolean)canRedo, (boolean)this.stack.canRedo());
        StringUndoStackBaseTest.assertEquals((String)model, (String)this.stack.getModel());
        StringUndoStackBaseTest.assertEquals((int)changeCount, (int)this.stack.getStackChangeCount());
    }
}

