/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.conqat.lib.commons.string.StringUtils;

public class StringUtilsTest
extends TestCase {
    private static final String[] TEST_ARRAY_3_ELEMENTS = new String[]{"1", "2", "3"};
    private static final String[] TEST_ARRAY_1_ELEMENTS = new String[]{"1"};
    private static final String[] TEST_ARRAY_0_ELEMENTS = new String[0];
    private static final String SPACE_TEXT = "A B  C   D";
    private static final String TAB_TEXT = "A\tB\tC\tD";
    private static final String NEW_LINE_TEXT = "A\nB\n\nC\n\n\nD\n";

    public void testConcatNullInput() {
        String concatenation = StringUtils.concat(null, "x");
        StringUtilsTest.assertNull((Object)concatenation);
    }

    public void testConcatNullSeparator() {
        String concatenation = StringUtils.concat((Object[])TEST_ARRAY_3_ELEMENTS, null);
        StringUtilsTest.assertEquals((String)"123", (String)concatenation);
    }

    public void testConcatWith3Elements() {
        String concatenation = StringUtils.concat((Object[])TEST_ARRAY_3_ELEMENTS, ":");
        StringUtilsTest.assertEquals((String)"1:2:3", (String)concatenation);
    }

    public void testConcatWith1Elements() {
        String concatenation = StringUtils.concat((Object[])TEST_ARRAY_1_ELEMENTS, ":");
        StringUtilsTest.assertEquals((String)"1", (String)concatenation);
    }

    public void testConcatWith0Elements() {
        String concatenation = StringUtils.concat((Object[])TEST_ARRAY_0_ELEMENTS, ":");
        StringUtilsTest.assertEquals((String)"", (String)concatenation);
    }

    public void testGetKeyValuePairs() {
        String testString = "a=1, b=2   ,     c=3,  d , e=5";
        HashMap<String, String> result = StringUtils.getKeyValuePairs(testString);
        StringUtilsTest.assertEquals((String)"1", (String)result.get("a"));
        StringUtilsTest.assertEquals((String)"2", (String)result.get("b"));
        StringUtilsTest.assertEquals((String)"3", (String)result.get("c"));
        StringUtilsTest.assertTrue((boolean)result.containsKey("d"));
        StringUtilsTest.assertNull((Object)result.get("d"));
        StringUtilsTest.assertEquals((String)"5", (String)result.get("e"));
    }

    public void testFillString() {
        String actual = StringUtils.fillString(3, '-');
        StringUtilsTest.assertEquals((String)"---", (String)actual);
        actual = StringUtils.fillString(1, '-');
        StringUtilsTest.assertEquals((String)"-", (String)actual);
        actual = StringUtils.fillString(0, '-');
        StringUtilsTest.assertEquals((String)"", (String)actual);
    }

    public void testCenter() {
        String actual = StringUtils.center("Test", 3, '-');
        StringUtilsTest.assertEquals((String)"Test", (String)actual);
        actual = StringUtils.center("Test", 10, '-');
        StringUtilsTest.assertEquals((String)"---Test---", (String)actual);
        actual = StringUtils.center("Test", 12, '-');
        StringUtilsTest.assertEquals((String)"----Test----", (String)actual);
        actual = StringUtils.center("Test", 11, '-');
        StringUtilsTest.assertEquals((String)"---Test----", (String)actual);
    }

    public void testFlushLeft() {
        String actual = StringUtils.flushLeft("Test", 3, '-');
        StringUtilsTest.assertEquals((String)"Test", (String)actual);
        actual = StringUtils.flushLeft("Test", 6, '-');
        StringUtilsTest.assertEquals((String)"Test--", (String)actual);
        actual = StringUtils.flushLeft("Test", 7, '-');
        StringUtilsTest.assertEquals((String)"Test---", (String)actual);
    }

    public void testFlushRight() {
        String actual = StringUtils.flushRight("Test", 3, '-');
        StringUtilsTest.assertEquals((String)"Test", (String)actual);
        actual = StringUtils.flushRight("Test", 6, '-');
        StringUtilsTest.assertEquals((String)"--Test", (String)actual);
        actual = StringUtils.flushRight("Test", 7, '-');
        StringUtilsTest.assertEquals((String)"---Test", (String)actual);
    }

    public void testRandomString() {
        String actual = StringUtils.randomString(10);
        StringUtilsTest.assertEquals((int)10, (int)actual.length());
        actual = StringUtils.randomString(1);
        StringUtilsTest.assertEquals((int)1, (int)actual.length());
        actual = StringUtils.randomString(0);
        StringUtilsTest.assertEquals((int)0, (int)actual.length());
    }

    public void testRandomStringArray() {
        String[] actual = StringUtils.randomStringArray(5, 10);
        StringUtilsTest.assertEquals((int)5, (int)actual.length);
        String[] stringArray = actual;
        int n = actual.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringUtilsTest.assertEquals((int)10, (int)s.length());
            ++n2;
        }
        actual = StringUtils.randomStringArray(1, 10);
        StringUtilsTest.assertEquals((int)1, (int)actual.length);
        StringUtilsTest.assertEquals((int)10, (int)actual[0].length());
        actual = StringUtils.randomStringArray(0, 10);
        StringUtilsTest.assertEquals((int)0, (int)actual.length);
    }

    public void testGenerateString() {
        String pseudoRandomString1 = StringUtils.generateString(100, 0);
        String pseudoRandomString2 = StringUtils.generateString(100, 0);
        StringUtilsTest.assertNotSame((Object)pseudoRandomString1, (Object)pseudoRandomString2);
        StringUtilsTest.assertEquals((String)pseudoRandomString1, (String)pseudoRandomString2);
    }

    public void testGenerateStringArray() {
        String[] array1 = StringUtils.generateStringArray(100, 50, 0);
        String[] array2 = StringUtils.generateStringArray(100, 50, 0);
        StringUtilsTest.assertNotSame((Object)array1, (Object)array2);
        StringUtilsTest.assertEquals((int)array1.length, (int)array2.length);
        StringUtilsTest.assertFalse((boolean)array1[0].equals(array1[1]));
        int i = 0;
        while (i < array1.length) {
            StringUtilsTest.assertEquals((String)array1[i], (String)array2[i]);
            ++i;
        }
    }

    public void testIsEmpty() {
        boolean actual = StringUtils.isEmpty("");
        StringUtilsTest.assertTrue((boolean)actual);
        actual = StringUtils.isEmpty("   ");
        StringUtilsTest.assertTrue((boolean)actual);
        actual = StringUtils.isEmpty("hallo");
        StringUtilsTest.assertFalse((boolean)actual);
        actual = StringUtils.isEmpty("  hallo  ");
        StringUtilsTest.assertFalse((boolean)actual);
        actual = StringUtils.isEmpty(null);
        StringUtilsTest.assertTrue((boolean)actual);
    }

    public void testMapToString() {
        String key;
        String line;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("test1", 1);
        map.put("test2", 2);
        map.put("test3", 3);
        String[] lines = StringUtils.splitLines(StringUtils.toString(map));
        Iterator keyIterator = map.keySet().iterator();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            key = (String)keyIterator.next();
            StringUtilsTest.assertEquals((String)(String.valueOf(key) + " = " + map.get(key)), (String)line);
            ++n2;
        }
        lines = StringUtils.splitLines(StringUtils.toString(map, "->"));
        keyIterator = map.keySet().iterator();
        stringArray = lines;
        n = lines.length;
        n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            key = (String)keyIterator.next();
            StringUtilsTest.assertEquals((String)("->" + key + " = " + map.get(key)), (String)line);
            ++n2;
        }
    }

    public void testSplitLines() {
        String[] actual = StringUtils.splitLines(StringUtils.concat((Object[])TEST_ARRAY_3_ELEMENTS, "\n"));
        this.assertEquals(TEST_ARRAY_3_ELEMENTS, actual);
        actual = StringUtils.splitLines(StringUtils.concat((Object[])TEST_ARRAY_3_ELEMENTS, "\r"));
        this.assertEquals(TEST_ARRAY_3_ELEMENTS, actual);
        actual = StringUtils.splitLines(StringUtils.concat((Object[])TEST_ARRAY_3_ELEMENTS, "\r\n"));
        this.assertEquals(TEST_ARRAY_3_ELEMENTS, actual);
        actual = StringUtils.splitLines("hallo");
        StringUtilsTest.assertEquals((int)1, (int)actual.length);
        StringUtilsTest.assertEquals((String)"hallo", (String)actual[0]);
        actual = StringUtils.splitLines("");
        StringUtilsTest.assertEquals((int)0, (int)actual.length);
        actual = StringUtils.splitLines(null);
        StringUtilsTest.assertEquals((int)0, (int)actual.length);
    }

    public void testIndexOf() {
        String[] testArray = new String[]{"test1", "test2", "test3"};
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOf(testArray, "test1"));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.indexOf(testArray, "test2"));
        StringUtilsTest.assertEquals((int)2, (int)StringUtils.indexOf(testArray, "test3"));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOf(testArray, "testX"));
        String[] testArray2 = new String[]{"test1"};
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.indexOf(testArray2, "test1"));
        StringUtilsTest.assertEquals((int)-1, (int)StringUtils.indexOf(testArray2, "testX"));
    }

    public void testReplaceLineBreaks() {
        String testString = "test1\r\ntest2\rtest3\ntest4";
        StringUtilsTest.assertEquals((String)"test1\\ntest2\\ntest3\\ntest4", (String)StringUtils.replaceLineBreaks(testString));
        StringUtilsTest.assertEquals((String)"test1xtest2xtest3xtest4", (String)StringUtils.replaceLineBreaks(testString, "x"));
    }

    public void testGetFirstLine() {
        StringUtilsTest.assertNull((Object)StringUtils.getFirstLine(null));
        StringUtilsTest.assertEquals((String)"test", (String)StringUtils.getFirstLine("test"));
        StringUtilsTest.assertEquals((String)"test", (String)StringUtils.getFirstLine("test\ntest1"));
        StringUtilsTest.assertEquals((String)"test", (String)StringUtils.getFirstLine("test\rtest1"));
        StringUtilsTest.assertEquals((String)"test", (String)StringUtils.getFirstLine("test\r\ntest1"));
    }

    public void testGetFirstParts() {
        String testString = "org.conqat.lib.commons";
        String result = StringUtils.getFirstParts(testString, 2, '.');
        StringUtilsTest.assertEquals((String)result, (String)"org.conqat");
    }

    public void testGetFirstPartsErrors() {
        String testString = "org.conqat.lib.commons";
        String result = StringUtils.getFirstParts(testString, -1, '.');
        StringUtilsTest.assertEquals((String)result, (String)testString);
        StringUtilsTest.assertEquals(null, (String)StringUtils.getFirstParts(null, 2, '.'));
    }

    public void testRemoveLastPart() {
        String testString = "org.conqat.lib.commons.string.StringUtils";
        String result = StringUtils.removeLastPart(testString, '.');
        StringUtilsTest.assertEquals((String)result, (String)"org.conqat.lib.commons.string");
    }

    public void testGetLastPart() {
        String testString = "org.conqat.lib.commons.string.StringUtils";
        String result = StringUtils.getLastPart(testString, '.');
        StringUtilsTest.assertEquals((String)result, (String)"StringUtils");
    }

    public void testStripPrefix() {
        StringUtilsTest.assertEquals((String)"hallo", (String)StringUtils.stripPrefix("pref", "hallo"));
        StringUtilsTest.assertEquals((String)"hallo", (String)StringUtils.stripPrefix("pref", "prefhallo"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.stripPrefix("pref", "pref"));
        StringUtilsTest.assertEquals((String)"pref", (String)StringUtils.stripPrefix("prefx", "pref"));
    }

    public void testStripSuffix() {
        StringUtilsTest.assertEquals((String)"hallo", (String)StringUtils.stripSuffix("suf", "hallo"));
        StringUtilsTest.assertEquals((String)"hallo", (String)StringUtils.stripSuffix("suf", "hallosuf"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.stripSuffix("suf", "suf"));
        StringUtilsTest.assertEquals((String)"suf", (String)StringUtils.stripSuffix("sufx", "suf"));
    }

    public void testStripDigits() {
        StringUtilsTest.assertEquals((String)"fbar", (String)StringUtils.stripDigits("f00bar"));
        StringUtilsTest.assertEquals((String)"fbar", (String)StringUtils.stripDigits("f00bar2000"));
        StringUtilsTest.assertEquals((String)"foobar", (String)StringUtils.stripDigits("foobar"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.stripDigits(""));
    }

    public void testObtainStackTrace() {
        Exception exception = new Exception();
        String stackTrace = StringUtils.obtainStackTrace(exception);
        StringUtilsTest.assertEquals((String)Exception.class.getName(), (String)StringUtils.splitLines(stackTrace)[0]);
        StringUtilsTest.assertTrue((boolean)StringUtils.splitLines(stackTrace)[1].contains(((Object)((Object)this)).getClass().getName()));
    }

    public void testStartsWithOneOf() {
        String string = "testString";
        StringUtilsTest.assertTrue((boolean)StringUtils.startsWithOneOf(string, "test"));
        StringUtilsTest.assertTrue((boolean)StringUtils.startsWithOneOf(string, "z", "test", "x"));
        StringUtilsTest.assertFalse((boolean)StringUtils.startsWithOneOf(string, "z", "y", "x"));
        StringUtilsTest.assertFalse((boolean)StringUtils.startsWithOneOf(string, new String[0]));
    }

    public void testEndsWithOneOf() {
        String string = "testString";
        StringUtilsTest.assertTrue((boolean)StringUtils.endsWithOneOf(string, "String"));
        StringUtilsTest.assertTrue((boolean)StringUtils.endsWithOneOf(string, "z", "String", "x"));
        StringUtilsTest.assertFalse((boolean)StringUtils.endsWithOneOf(string, "z", "y", "x"));
        StringUtilsTest.assertFalse((boolean)StringUtils.endsWithOneOf(string, new String[0]));
    }

    public void testPrefixLines() {
        String string = "this\nis\na\ntest";
        StringUtilsTest.assertEquals((String)StringUtils.normalizeLineBreaks("xthis\nxis\nxa\nxtest"), (String)StringUtils.prefixLines(string, "x", true));
        StringUtilsTest.assertEquals((String)StringUtils.normalizeLineBreaks("this\nxis\nxa\nxtest"), (String)StringUtils.prefixLines(string, "x", false));
        StringUtilsTest.assertEquals((String)StringUtils.normalizeLineBreaks("xthis"), (String)StringUtils.prefixLines("this", "x", true));
        StringUtilsTest.assertEquals((String)StringUtils.normalizeLineBreaks("this"), (String)StringUtils.prefixLines("this", "x", false));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.prefixLines("", "x", false));
    }

    private void assertEquals(String[] array1, String[] array2) {
        StringUtilsTest.assertEquals((int)array1.length, (int)array2.length);
        int i = 0;
        while (i < array1.length) {
            StringUtilsTest.assertEquals((String)array1[i], (String)array2[i]);
            ++i;
        }
    }

    public void testCapitalize() {
        StringUtilsTest.assertEquals((String)"Test", (String)StringUtils.capitalize("test"));
        StringUtilsTest.assertEquals((String)"Test", (String)StringUtils.capitalize("Test"));
        StringUtilsTest.assertEquals((String)"TeST", (String)StringUtils.capitalize("teST"));
        StringUtilsTest.assertEquals((String)"T", (String)StringUtils.capitalize("t"));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.capitalize(""));
    }

    public void testWrapLongLines() {
        this.testWrapLongLinesWith("This is a text which should be wrapped neatly", 20);
        this.testWrapLongLinesWith("This is a text which should be wrapped neatly", 5);
    }

    public void testLongestCommonPrefixListOfString() {
        ArrayList<String> strings = new ArrayList<String>();
        String prefix = "C:/ConQAT/";
        strings.add(String.valueOf(prefix) + "a");
        strings.add(String.valueOf(prefix) + "b");
        strings.add(String.valueOf(prefix) + "c");
        String result = StringUtils.longestCommonPrefix(strings);
        Assert.assertEquals((String)prefix, (String)result);
        strings = new ArrayList();
        strings.add("xyz");
        strings.add("abc");
        Assert.assertEquals((String)"", (String)StringUtils.longestCommonPrefix(strings));
    }

    private void testWrapLongLinesWith(String testString, int length) {
        String result = StringUtils.wrapLongLines(testString, length);
        StringUtilsTest.assertEquals((String)"String must be same after normalization", (String)testString.replaceAll("\\s+", " "), (String)result.replaceAll("\\s+", " "));
        String[] stringArray = StringUtils.splitLines(result);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > length && line.contains(" ")) {
                StringUtilsTest.fail((String)("Too long lines may not contain multiple words: " + line));
            }
            ++n2;
        }
    }

    private void assertWhiteSpaceRemoved(String text, String expectation, String errorMessage) {
        text = StringUtils.removeWhitespace(text);
        StringUtilsTest.assertEquals((String)errorMessage, (String)text, (String)expectation);
    }

    public void testSpace() {
        this.assertWhiteSpaceRemoved(SPACE_TEXT, "ABCD", "Invalid space removal!");
    }

    public void testTab() {
        this.assertWhiteSpaceRemoved(TAB_TEXT, "ABCD", "Invalid tab removal!");
    }

    public void testNewLine() {
        this.assertWhiteSpaceRemoved(NEW_LINE_TEXT, "ABCD", "Invalid CR removal!");
    }

    public void testSpaceAndTab() {
        this.assertWhiteSpaceRemoved("A B  C   DA\tB\tC\tD", "ABCDABCD", "Invalid space or tab removal!");
    }

    public void testSpaceAndNewLine() {
        this.assertWhiteSpaceRemoved("A B  C   DA\nB\n\nC\n\n\nD\n", "ABCDABCD", "Invalid space or CR removal!");
    }

    public void testTabAndNewLine() {
        this.assertWhiteSpaceRemoved("A\tB\tC\tDA\nB\n\nC\n\n\nD\n", "ABCDABCD", "Invalid tab or CR removal!");
    }

    public void testSpaceTabAndNewLine() {
        this.assertWhiteSpaceRemoved("A B  C   DA\tB\tC\tDA\nB\n\nC\n\n\nD\n", "ABCDABCDABCD", "Invaid space, tab or CR removal!");
    }

    public void testEscapeRegexReplacementString() {
        StringUtilsTest.assertEquals((String)"a\\\\b\\$c", (String)StringUtils.escapeRegexReplacementString("a\\b$c"));
    }
}

