/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.system;

import org.conqat.lib.commons.system.EPerformanceMonitorState;
import org.conqat.lib.commons.system.MemoryMonitor;

public class PerformanceMonitor {
    private EPerformanceMonitorState state = EPerformanceMonitorState.NOT_RUN;
    private long startTimeInMillis;
    private long stopTimeInMillis;
    private MemoryMonitor memMonitor;
    private final boolean useMemoryMonitor;
    private long startMemoryInBytes;
    private long stopMemoryInBytes;

    public static PerformanceMonitor create(boolean useMemoryMonitor) {
        PerformanceMonitor monitor = new PerformanceMonitor(useMemoryMonitor);
        monitor.start();
        return monitor;
    }

    public static PerformanceMonitor create() {
        return PerformanceMonitor.create(false);
    }

    PerformanceMonitor(boolean useMemoryMonitor) {
        this.useMemoryMonitor = useMemoryMonitor;
    }

    public void start() {
        if (this.state != EPerformanceMonitorState.NOT_RUN) {
            throw new IllegalStateException("PerformanceMonitor is already running and cannot be restarted");
        }
        this.state = EPerformanceMonitorState.RUNNING;
        if (this.useMemoryMonitor) {
            this.memMonitor = new MemoryMonitor();
            this.memMonitor.start();
        }
        this.startMemoryInBytes = Runtime.getRuntime().totalMemory();
        this.startTimeInMillis = System.currentTimeMillis();
    }

    public void stop() {
        if (this.state != EPerformanceMonitorState.RUNNING) {
            throw new IllegalStateException("PerformanceMonitor can only be stopped if it is running");
        }
        this.stopTimeInMillis = System.currentTimeMillis();
        if (this.useMemoryMonitor) {
            this.memMonitor.stop();
        }
        this.stopMemoryInBytes = Runtime.getRuntime().totalMemory();
        this.state = EPerformanceMonitorState.FINISHED;
    }

    public long getSeconds() {
        return this.getMilliseconds() / 1000L;
    }

    public long getMilliseconds() {
        return this.stopTimeInMillis - this.startTimeInMillis;
    }

    public long getMaxMemUsageInBytes() {
        if (this.useMemoryMonitor) {
            return this.memMonitor.getMaximumMemoryUsage();
        }
        return Math.max(this.stopMemoryInBytes, this.startMemoryInBytes);
    }

    public long getMaxMemUsageInKBs() {
        return this.getMaxMemUsageInBytes() / 1024L;
    }

    public long getDeltaMemUsageInBytes() {
        return this.getMaxMemUsageInBytes() - this.startMemoryInBytes;
    }

    public long getDeltaMemUsageInKBs() {
        return this.getDeltaMemUsageInBytes() / 1024L;
    }
}

