/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.system;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.conqat.lib.commons.system.PerformanceMonitor;

public class PerformanceMonitorTest
extends TestCase {
    PerformanceMonitor monitor;

    protected void setUp() throws Exception {
        super.setUp();
        this.monitor = PerformanceMonitor.create();
    }

    public void testSmoke() {
        int i = 0;
        while (i < 100000) {
            new ArrayList(100);
            ++i;
        }
        this.monitor.stop();
        PerformanceMonitorTest.assertTrue((this.monitor.getMaxMemUsageInBytes() > 0L ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getMilliseconds() > 0L ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getMaxMemUsageInBytes() > this.monitor.getMaxMemUsageInKBs() ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getMilliseconds() > this.monitor.getSeconds() ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getDeltaMemUsageInBytes() >= 0L ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getDeltaMemUsageInKBs() >= 0L ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getDeltaMemUsageInBytes() <= this.monitor.getMaxMemUsageInBytes() ? 1 : 0) != 0);
        PerformanceMonitorTest.assertTrue((this.monitor.getDeltaMemUsageInKBs() <= this.monitor.getMaxMemUsageInKBs() ? 1 : 0) != 0);
    }

    public void testCannotStartTwice() {
        try {
            this.monitor.start();
            PerformanceMonitorTest.fail((String)"It should not be possible to start a monitor twice");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCannotStopBeforeStart() {
        try {
            new PerformanceMonitor(false).stop();
            PerformanceMonitorTest.fail((String)"It should not be possible to stop the PerformanceMonitor before it gets started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCannotStopTwice() {
        try {
            this.monitor.stop();
            this.monitor.stop();
            PerformanceMonitorTest.fail((String)"It should not be possible to stop the PerformanceMonitor more than once");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCannotRestartPerformanceMonitor() {
        try {
            this.monitor.stop();
            this.monitor.start();
            PerformanceMonitorTest.fail((String)"It should not be possible to restart the PerformanceMonitor more than once");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

