/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class TestDataManager {
    public static final String REPORT_DIRECTORY_NAME = "test-tmp";
    private static Map<File, TestDataManager> instances = new HashMap<File, TestDataManager>();
    private final HashSet<String> unusedFiles = new HashSet();
    private final TwoDimHashMap<Class<?>, TestCase, HashSet<String>> usedFiles = new TwoDimHashMap();
    private final File directory;

    public static TestDataManager getInstance(File directory) {
        if (!instances.containsKey(directory)) {
            instances.put(directory, new TestDataManager(directory));
        }
        return instances.get(directory);
    }

    private TestDataManager(File directory) {
        this.directory = directory;
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.unusedFiles.add(file.getName());
            }
            ++n2;
        }
    }

    public File getTestFile(String filename, TestCase testCase) {
        HashSet<String> set = this.usedFiles.getValue(testCase.getClass(), testCase);
        if (set == null) {
            set = new HashSet();
            this.usedFiles.putValue(testCase.getClass(), testCase, set);
        }
        set.add(filename);
        this.unusedFiles.remove(filename);
        this.updateUsageReports();
        return new File(this.directory, filename);
    }

    private void updateUsageReports() {
        try {
            File baseDir = new File(REPORT_DIRECTORY_NAME);
            FileSystemUtils.ensureDirectoryExists(baseDir);
            String fname = this.directory.toString().replaceAll("[\\\\/]", "_");
            PrintWriter pw = new PrintWriter(new FileWriter(new File(baseDir, String.valueOf(fname) + "_usage.txt")));
            this.printUsedFiles(pw);
            pw.close();
            pw = new PrintWriter(new FileWriter(new File(baseDir, String.valueOf(fname) + "_unusage.txt")));
            this.printUnusedFiles(pw);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printUnusedFiles(PrintWriter pw) {
        pw.println("Unused files for directory " + this.directory + ": " + this.unusedFiles.size());
        ArrayList<String> fileList = new ArrayList<String>(this.unusedFiles);
        Collections.sort(fileList);
        for (String filename : fileList) {
            pw.print("  ");
            pw.println(filename);
        }
        pw.flush();
    }

    public void printUsedFiles(PrintWriter pw) {
        pw.println("Used files for directory " + this.directory);
        for (Class<?> clazz : this.usedFiles.getFirstKeys()) {
            pw.print("  ");
            pw.println(clazz.getName());
            for (TestCase testCase : this.usedFiles.getSecondKeys(clazz)) {
                pw.print("    ");
                pw.println(testCase.getName());
                for (String filename : this.usedFiles.getValue(clazz, testCase)) {
                    pw.print("      ");
                    pw.println(filename);
                }
            }
            pw.println();
        }
        pw.flush();
    }
}

