/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.version;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.error.FormatException;

public class Version
implements Comparable<Version>,
Serializable {
    private final int major;
    private final int minor;

    public Version(int major, int minor) {
        if (major < 0 || minor < 0) {
            throw new IllegalArgumentException("Versions may not be less than 0.");
        }
        this.major = major;
        this.minor = minor;
    }

    public static Version parseVersion(String s) throws FormatException {
        Matcher m = Pattern.compile("\\s*(\\d+)\\.(\\d+)\\s*").matcher(s);
        if (!m.matches()) {
            throw new FormatException("The provided string did not match the pattern!");
        }
        return new Version(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
    }

    @Override
    public int compareTo(Version other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return this.major << 7 | this.minor;
    }

    public boolean isSatisfied(Version currentVersion, Version compatibleVersion) {
        if (compatibleVersion.compareTo(currentVersion) > 0) {
            throw new IllegalArgumentException("Compatible version greater than current version.");
        }
        return this.compareTo(currentVersion) <= 0 && this.compareTo(compatibleVersion) >= 0;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor;
    }
}

