/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.version;

import junit.framework.TestCase;
import org.conqat.lib.commons.version.Version;

public class VersionTest
extends TestCase {
    public void testCompareEqual() {
        VersionTest.assertEquals((int)0, (int)new Version(1, 0).compareTo(new Version(1, 0)));
        VersionTest.assertEquals((int)0, (int)new Version(0, 0).compareTo(new Version(0, 0)));
    }

    public void testCompareLessThan() {
        VersionTest.assertEquals((int)-1, (int)new Version(1, 0).compareTo(new Version(2, 0)));
        VersionTest.assertEquals((int)-1, (int)new Version(0, 0).compareTo(new Version(1, 0)));
        VersionTest.assertEquals((int)-1, (int)new Version(1, 0).compareTo(new Version(1, 3)));
    }

    public void testCompareGreaterThan() {
        VersionTest.assertEquals((int)1, (int)new Version(2, 0).compareTo(new Version(1, 0)));
        VersionTest.assertEquals((int)1, (int)new Version(1, 0).compareTo(new Version(0, 0)));
        VersionTest.assertEquals((int)1, (int)new Version(1, 3).compareTo(new Version(1, 0)));
    }

    public void testEquals() {
        VersionTest.assertEquals((Object)new Version(1, 0), (Object)new Version(1, 0));
        VersionTest.assertFalse((boolean)new Version(1, 0).equals(new Version(2, 0)));
    }

    public void testIsSatisfied() {
        Version currentVersion = new Version(1, 5);
        Version compatibleVersion = new Version(1, 1);
        VersionTest.assertFalse((boolean)new Version(1, 6).isSatisfied(currentVersion, compatibleVersion));
        VersionTest.assertFalse((boolean)new Version(1, 0).isSatisfied(currentVersion, compatibleVersion));
        VersionTest.assertTrue((boolean)new Version(1, 5).isSatisfied(currentVersion, compatibleVersion));
        VersionTest.assertTrue((boolean)new Version(1, 1).isSatisfied(currentVersion, compatibleVersion));
        VersionTest.assertTrue((boolean)new Version(1, 4).isSatisfied(currentVersion, compatibleVersion));
        VersionTest.assertTrue((boolean)new Version(1, 3).isSatisfied(currentVersion, compatibleVersion));
    }
}

