/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.version.Version;

public class VersionUtils {
    public static void checkForNewVersion(final String appName, String versionFileUrl, Version runningVersion) {
        Version currentVersion;
        try {
            currentVersion = VersionUtils.getMostRecentVersion(versionFileUrl);
        }
        catch (Exception e) {
            return;
        }
        if (currentVersion.compareTo(runningVersion) > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "The newer version " + currentVersion + " of " + appName + " is available for download!", "Update available", 1);
                }
            });
        }
    }

    public static Version getMostRecentVersion(String versionFileUrl) throws IOException, FormatException {
        URL versionURL = new URL(versionFileUrl);
        InputStream in = versionURL.openStream();
        String versionString = FileSystemUtils.readStream(in);
        in.close();
        return Version.parseVersion(versionString);
    }
}

