/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.visitor;

import java.util.Collection;
import java.util.Set;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.ITreeWalker;
import org.conqat.lib.commons.visitor.IVisitor;

public class VisitorUtils {
    public static <T, X1 extends Exception, X2 extends Exception> void visitAllPreOrder(T root, ITreeWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        visitor.visit(root);
        for (T child : walker.getChildren(root)) {
            VisitorUtils.visitAllPreOrder(child, walker, visitor);
        }
    }

    public static <T, X1 extends Exception, X2 extends Exception> void visitLeaves(T root, ITreeWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        Collection<T> children = walker.getChildren(root);
        if (children.isEmpty()) {
            visitor.visit(root);
        } else {
            for (T child : children) {
                VisitorUtils.visitLeaves(child, walker, visitor);
            }
        }
    }

    public static <T, X1 extends Exception, X2 extends Exception> void visitAllDepthFirst(T start, IMeshWalker<T, X1> walker, IVisitor<T, X2> visitor) throws X1, X2 {
        IdentityHashSet<T> seen = new IdentityHashSet<T>();
        seen.add(start);
        VisitorUtils.visitAllDepthFirst(start, walker, visitor, seen);
    }

    private static <T, X1 extends Exception, X2 extends Exception> void visitAllDepthFirst(T start, IMeshWalker<T, X1> walker, IVisitor<T, X2> visitor, Set<T> seen) throws X1, X2 {
        visitor.visit(start);
        for (T element : walker.getAdjacentElements(start)) {
            if (!seen.add(element)) continue;
            VisitorUtils.visitAllDepthFirst(element, walker, visitor, seen);
        }
    }
}

