/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.ITreeWalker;
import org.conqat.lib.commons.visitor.IVisitor;
import org.conqat.lib.commons.visitor.VisitorUtils;

public class VisitorUtilsTest
extends TestCase {
    public void testVisitTree() {
        ArrayList root = new ArrayList();
        ArrayList ch1 = new ArrayList();
        ArrayList<Object> ch2 = new ArrayList<Object>();
        ArrayList<String> ch3 = new ArrayList<String>();
        root.add(ch1);
        root.add(ch2);
        ch2.add(ch3);
        ch2.add("a");
        ch2.add("b");
        ch2.add("c");
        ch3.add("d");
        ch3.add("e");
        CountingVisitor cv = new CountingVisitor();
        VisitorUtils.visitAllPreOrder(root, new ListWalker(), cv);
        VisitorUtilsTest.assertEquals((int)9, (int)cv.counter);
        cv.counter = 0;
        VisitorUtils.visitLeaves(root, new ListWalker(), cv);
        VisitorUtilsTest.assertEquals((int)6, (int)cv.counter);
    }

    public void testVisitMesh() {
        ArrayList elem1 = new ArrayList();
        ArrayList elem2 = new ArrayList();
        ArrayList elem3 = new ArrayList();
        ArrayList elem4 = new ArrayList();
        elem1.add(elem2);
        elem1.add(elem4);
        elem2.add(elem1);
        elem2.add(elem4);
        elem2.add(elem4);
        elem2.add(elem1);
        elem2.add(elem4);
        elem4.add(elem3);
        CountingVisitor cv = new CountingVisitor();
        VisitorUtils.visitAllDepthFirst(elem1, new ListWalker(), cv);
        VisitorUtilsTest.assertEquals((int)4, (int)cv.counter);
    }

    public static class CountingVisitor
    implements IVisitor<Object, NeverThrownRuntimeException> {
        public int counter = 0;

        @Override
        public void visit(Object element) {
            ++this.counter;
        }
    }

    public static class ListWalker
    implements ITreeWalker<Object, NeverThrownRuntimeException>,
    IMeshWalker<Object, NeverThrownRuntimeException> {
        @Override
        public Collection<Object> getChildren(Object node) throws NeverThrownRuntimeException {
            if (node instanceof List) {
                return (List)node;
            }
            return CollectionUtils.emptyList();
        }

        @Override
        public Collection<Object> getAdjacentElements(Object element) throws NeverThrownRuntimeException {
            return this.getChildren(element);
        }
    }
}

