/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLReader<E extends Enum<E>, A extends Enum<A>, X extends Exception> {
    private Element currentDOMElement;
    private final URL schemaURL;
    private final IXMLResolver<E, A> xmlResolver;
    private final Reader reader;

    public XMLReader(File file, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(file, null, null, xmlResolver);
    }

    public XMLReader(File file, String encoding, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(file, encoding, null, xmlResolver);
    }

    public XMLReader(File file, URL schemaURL, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(file, null, schemaURL, xmlResolver);
    }

    public XMLReader(File file, String encoding, URL schemaURL, IXMLResolver<E, A> xmlResolver) throws IOException {
        this(FileSystemUtils.streamReader(new FileInputStream(file), XMLReader.ensureNotNullEncoding(encoding)), schemaURL, xmlResolver);
    }

    private static String ensureNotNullEncoding(String encoding) {
        if (encoding == null) {
            return Charset.defaultCharset().name();
        }
        return encoding;
    }

    public XMLReader(Reader reader, URL schemaURL, IXMLResolver<E, A> xmlResolver) {
        CCSMPre.isFalse(reader == null, "Reader may not be null.");
        CCSMPre.isFalse(xmlResolver == null, "XML resolver may not be null.");
        this.reader = reader;
        this.schemaURL = schemaURL;
        this.xmlResolver = xmlResolver;
    }

    public XMLReader(String content, URL schemaURL, IXMLResolver<E, A> xmlResolver) {
        this(new StringReader(content), schemaURL, xmlResolver);
    }

    protected boolean getBooleanAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Boolean.valueOf(value);
    }

    protected String getChildText(E childElement) {
        String elementName = this.xmlResolver.resolveElementName(childElement);
        Element domElement = XMLUtils.getNamedChild(this.currentDOMElement, elementName);
        if (domElement == null) {
            return null;
        }
        return domElement.getTextContent();
    }

    protected <T extends Enum<T>> T getEnumAttribute(A attribute, Class<T> enumClass) {
        String value = this.getStringAttribute(attribute);
        return Enum.valueOf(enumClass, value);
    }

    protected int getIntAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Integer.valueOf(value);
    }

    protected long getLongAttribute(A attribute) {
        String value = this.getStringAttribute(attribute);
        return Long.valueOf(value);
    }

    protected String getStringAttribute(A attribute) {
        return this.currentDOMElement.getAttribute(this.xmlResolver.resolveAttributeName(attribute));
    }

    protected String getText() {
        return this.currentDOMElement.getTextContent();
    }

    protected void parseFile() throws SAXException, IOException {
        try {
            InputSource input = new InputSource(this.reader);
            Document document = this.schemaURL == null ? XMLUtils.parse(input) : XMLUtils.parse(input, this.schemaURL);
            this.currentDOMElement = document.getDocumentElement();
        }
        finally {
            this.reader.close();
        }
    }

    protected void processChildElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        this.processElementList(processor, XMLUtils.getNamedChildren(this.currentDOMElement, targetElementName));
    }

    protected void processDecendantElements(IXMLElementProcessor<E, X> processor) throws X {
        String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
        NodeList descendantNodes = this.currentDOMElement.getElementsByTagName(targetElementName);
        this.processElementList(processor, XMLUtils.elementNodes(descendantNodes));
    }

    private void processElementList(IXMLElementProcessor<E, X> processor, List<Element> elements) throws X {
        Element oldElement = this.currentDOMElement;
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element child;
            this.currentDOMElement = child = iterator.next();
            processor.process();
        }
        this.currentDOMElement = oldElement;
    }

    protected void apply(IXMLElementProcessor<E, X> ... processors) throws X {
        HashMap<String, IXMLElementProcessor<E, X>> processorMap = new HashMap<String, IXMLElementProcessor<E, X>>();
        IXMLElementProcessor<E, X>[] iXMLElementProcessorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLElementProcessor<E, X> processor = iXMLElementProcessorArray[n2];
            String targetElementName = this.xmlResolver.resolveElementName(processor.getTargetElement());
            CCSMPre.isFalse(processorMap.containsKey(targetElementName), "Multiple processors found for element: " + targetElementName);
            processorMap.put(targetElementName, processor);
            ++n2;
        }
        Element oldElement = this.currentDOMElement;
        this.traverse(processorMap);
        this.currentDOMElement = oldElement;
    }

    private void traverse(Map<String, IXMLElementProcessor<E, X>> processorMap) throws X {
        IXMLElementProcessor<E, X> processor = processorMap.get(this.currentDOMElement.getTagName());
        if (processor != null) {
            processor.process();
        }
        NodeList nodeList = this.currentDOMElement.getChildNodes();
        Iterator<Element> iterator = XMLUtils.elementNodes(nodeList).iterator();
        while (iterator.hasNext()) {
            Element element;
            this.currentDOMElement = element = iterator.next();
            this.traverse(processorMap);
        }
    }
}

