/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.File;
import java.util.List;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.commons.xml.XMLUtils;
import org.conqat.lib.commons.xml.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathEvaluatorTest
extends CCSMTestCaseBase {
    private final XPathEvaluator xPath = new XPathEvaluator();
    private Element element;

    protected void setUp() throws Exception {
        File file = this.useTestFile("xpath01.xml");
        Document doc = XMLUtils.parse(file);
        this.element = doc.getDocumentElement();
    }

    public void testNameSpacePrefix() {
        XPathEvaluatorTest.assertNull((Object)this.xPath.selectElement("//ORDER[@article-number=5]", this.element));
        this.xPath.addNamespace("ns", "http://mynamespace.com");
        XPathEvaluatorTest.assertNotNull((Object)this.xPath.selectElement("//ns:ORDER[@article-number=5]", this.element));
    }

    public void testSelectBoolean() {
        XPathEvaluatorTest.assertFalse((boolean)this.xPath.selectBoolean("//XZY", this.element));
        XPathEvaluatorTest.assertTrue((boolean)this.xPath.selectBoolean("//STREET", this.element));
    }

    public void testSelectElement() {
        XPathEvaluatorTest.assertNull((Object)this.xPath.selectElement("//XZY", this.element));
        XPathEvaluatorTest.assertNotNull((Object)this.xPath.selectElement("//STREET", this.element));
        XPathEvaluatorTest.assertSame((Object)this.xPath.selectElement("//ORDER", this.element), (Object)this.xPath.selectElement("//ORDER", this.element));
        XPathEvaluatorTest.assertNotSame((Object)this.xPath.selectElement("//ORDER[1]", this.element), (Object)this.xPath.selectElement("//ORDER[2]", this.element));
    }

    public void testSelectList() {
        List<Element> list = this.xPath.selectList("//ORDER", this.element);
        XPathEvaluatorTest.assertEquals((int)4, (int)list.size());
        int i = 0;
        while (i < list.size()) {
            XPathEvaluatorTest.assertEquals((Object)list.get(i), (Object)this.xPath.selectElement("//ORDER[@article-number=" + (i + 1) + "]", this.element));
            ++i;
        }
    }

    public void testSelectNumber() {
        XPathEvaluatorTest.assertEquals((int)1, (int)this.xPath.selectInt("//ORDER/@article-number", this.element));
        XPathEvaluatorTest.assertEquals((Object)1.0, (Object)this.xPath.selectDouble("//ORDER/@article-number", this.element));
        XPathEvaluatorTest.assertEquals((int)2, (int)this.xPath.selectInt("count(//STREET)", this.element));
    }

    public void testSelectString() {
        XPathEvaluatorTest.assertEquals((String)"Street A", (String)this.xPath.selectString("//STREET", this.element));
        XPathEvaluatorTest.assertEquals((String)"Street B", (String)this.xPath.selectString("//STREET[.='Street B']", this.element));
        XPathEvaluatorTest.assertEquals((String)"", (String)this.xPath.selectString("//unknown-element", this.element));
    }
}

