/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class AdaScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.ADA;
    }

    public void testErrorCases() throws IOException {
        this.assertTokens("\"A; test", ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.SEMICOLON, ETokenType.IDENTIFIER);
        this.assertTokens("'A; test", ETokenType.SINGLE_QUOTE, ETokenType.IDENTIFIER, ETokenType.SEMICOLON, ETokenType.IDENTIFIER);
        this.assertTokens("12.", ETokenType.FLOATING_POINT_LITERAL, ETokenType.DOT);
        this.assertTokens("016#03", ETokenType.FLOATING_POINT_LITERAL, ETokenType.ILLEGAL_CHARACTER, ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testIdentifier() throws IOException {
        this.assertToken("Count", ETokenType.IDENTIFIER);
        this.assertToken("X", ETokenType.IDENTIFIER);
        this.assertToken("Get_Symbol", ETokenType.IDENTIFIER);
        this.assertToken("Ethelyn", ETokenType.IDENTIFIER);
        this.assertToken("Marion", ETokenType.IDENTIFIER);
        this.assertToken("Snobol_4", ETokenType.IDENTIFIER);
        this.assertToken("X1", ETokenType.IDENTIFIER);
        this.assertToken("Page_Count", ETokenType.IDENTIFIER);
        this.assertToken("Store_Next_Item", ETokenType.IDENTIFIER);
    }

    public void testDecimalLiterals() throws IOException {
        this.assertToken("12", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("1E6", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("123_456", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("12.0", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.0", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.456", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("3.14159_26", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBasedLiterals() throws IOException {
        this.assertToken("2#1111_1111#", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("16#FF#", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("016#0ff#", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("16#E#E1", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("2#1110_0000#", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("16#F.FF#E+2", ETokenType.BASED_FLOATING_POINT_LITERAL);
        this.assertToken("2#1.1111_1111_1110#E11", ETokenType.BASED_FLOATING_POINT_LITERAL);
    }

    public void testCharacterLiterals() throws IOException {
        this.assertToken("'A'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'*'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'''", ETokenType.CHARACTER_LITERAL);
        this.assertToken("' '", ETokenType.CHARACTER_LITERAL);
    }

    public void testStringLiterals() throws IOException {
        this.assertToken("\"Message of the day:\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"\"", ETokenType.STRING_LITERAL);
        this.assertToken("\" \"", ETokenType.STRING_LITERAL);
        this.assertToken("\"A\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"\"\"\"", ETokenType.STRING_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertToken("--  the last sentence above echoes the Algol 68 report", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("--  a long comment may be split onto" + StringUtils.CR + "-- two or more consecutive lines", ETokenType.END_OF_LINE_COMMENT, ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("---------------- the first two hyphens start the comment", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("end; ---------------- the first two hyphens start the comment", ETokenType.END, ETokenType.SEMICOLON, ETokenType.END_OF_LINE_COMMENT);
    }

    public void testKeywords() throws IOException {
        this.assertToken("abort", ETokenType.ABORT);
        this.assertToken("abs", ETokenType.ABS);
        this.assertToken("abstract", ETokenType.ABSTRACT);
        this.assertToken("accept", ETokenType.ACCEPT);
        this.assertToken("access", ETokenType.ACCESS);
        this.assertToken("aliased", ETokenType.ALIAS);
        this.assertToken("all", ETokenType.ALL);
        this.assertToken("and", ETokenType.AND);
        this.assertToken("array", ETokenType.ARRAY);
        this.assertToken("at", ETokenType.AT);
        this.assertToken("begin", ETokenType.BEGIN);
        this.assertToken("body", ETokenType.BODY);
        this.assertToken("case", ETokenType.CASE);
        this.assertToken("constant", ETokenType.CONSTANT);
        this.assertToken("declare", ETokenType.DECLARE);
        this.assertToken("delay", ETokenType.DELAY);
        this.assertToken("delta", ETokenType.DELTA);
        this.assertToken("digits", ETokenType.DIGITS);
        this.assertToken("do", ETokenType.DO);
        this.assertToken("else", ETokenType.ELSE);
        this.assertToken("elsif", ETokenType.ELSEIF);
        this.assertToken("end", ETokenType.END);
        this.assertToken("entry", ETokenType.ENTRY);
        this.assertToken("exception", ETokenType.EXCEPTION);
        this.assertToken("exit", ETokenType.EXIT);
        this.assertToken("for", ETokenType.FOR);
        this.assertToken("function", ETokenType.FUNCTION);
        this.assertToken("generic", ETokenType.GENERIC);
        this.assertToken("goto", ETokenType.GOTO);
        this.assertToken("if", ETokenType.IF);
        this.assertToken("in", ETokenType.IN);
        this.assertToken("is", ETokenType.IS);
        this.assertToken("limited", ETokenType.LIMITED);
        this.assertToken("loop", ETokenType.LOOP);
        this.assertToken("mod", ETokenType.MOD);
        this.assertToken("new", ETokenType.NEW);
        this.assertToken("not", ETokenType.NOT);
        this.assertToken("null", ETokenType.NULL);
        this.assertToken("of", ETokenType.OF);
        this.assertToken("or", ETokenType.OR);
        this.assertToken("others", ETokenType.OTHERS);
        this.assertToken("out", ETokenType.OUT);
        this.assertToken("package", ETokenType.PACKAGE);
        this.assertToken("private", ETokenType.PRIVATE);
        this.assertToken("procedure", ETokenType.PROCEDURE);
        this.assertToken("protected", ETokenType.PROTECTED);
        this.assertToken("raise", ETokenType.RAISE);
        this.assertToken("range", ETokenType.RANGE);
        this.assertToken("record", ETokenType.RECORD);
        this.assertToken("rem", ETokenType.REM);
        this.assertToken("renames", ETokenType.RENAMES);
        this.assertToken("requeue", ETokenType.REQUEUE);
        this.assertToken("return", ETokenType.RETURN);
        this.assertToken("reverse", ETokenType.REVERSE);
        this.assertToken("select", ETokenType.SELECT);
        this.assertToken("separate", ETokenType.SEPARATE);
        this.assertToken("subtype", ETokenType.SUBTYPE);
        this.assertToken("tagged", ETokenType.TAGGED);
        this.assertToken("task", ETokenType.TASK);
        this.assertToken("terminate", ETokenType.TERMINATE);
        this.assertToken("then", ETokenType.THEN);
        this.assertToken("type", ETokenType.TYPE);
        this.assertToken("until", ETokenType.UNTIL);
        this.assertToken("use", ETokenType.USE);
        this.assertToken("when", ETokenType.WHEN);
        this.assertToken("while", ETokenType.WHILE);
        this.assertToken("with", ETokenType.WITH);
        this.assertToken("xor", ETokenType.XOR);
    }

    public void testOperators() throws IOException {
        this.assertToken("*", ETokenType.MULT);
        this.assertToken("&", ETokenType.AND);
        this.assertToken("+", ETokenType.PLUS);
        this.assertToken("-", ETokenType.MINUS);
        this.assertToken("/", ETokenType.DIV);
        this.assertToken("<", ETokenType.LT);
        this.assertToken("=", ETokenType.EQ);
        this.assertToken(">", ETokenType.GT);
        this.assertToken("|", ETokenType.OR);
        this.assertToken("..", ETokenType.DOUBLE_DOT);
        this.assertToken("**", ETokenType.DOUBLE_STAR);
        this.assertToken(":=", ETokenType.ASSIGNMENT);
        this.assertToken("/=", ETokenType.NOTEQ);
        this.assertToken("<=", ETokenType.LTEQ);
        this.assertToken(">=", ETokenType.GTEQ);
    }

    public void testDelimiters() throws IOException {
        this.assertToken("(", ETokenType.LPAREN);
        this.assertToken(")", ETokenType.RPAREN);
        this.assertToken(",", ETokenType.COMMA);
        this.assertToken(".", ETokenType.DOT);
        this.assertToken(":", ETokenType.COLON);
        this.assertToken(";", ETokenType.SEMICOLON);
        this.assertToken("'", ETokenType.SINGLE_QUOTE);
        this.assertToken("<<", ETokenType.LEFT_LABEL_BRACKET);
        this.assertToken(">>", ETokenType.RIGHT_LABEL_BRACKET);
        this.assertToken("<>", ETokenType.BOX);
    }

    public void testPragmas() throws IOException {
        this.assertToken("pragma List(Off);", ETokenType.PREPROCESSOR_DIRECTIVE);
    }

    public void testSemicolonHandling() throws IOException {
        this.assertTokens(";(;);", ETokenType.SEMICOLON, ETokenType.LPAREN, ETokenType.PARAMETER_SEPARATOR, ETokenType.RPAREN, ETokenType.SEMICOLON);
        this.assertTokens("abc (foo : int; bar : int := (1+2); baz: string);", ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER, ETokenType.PARAMETER_SEPARATOR, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER, ETokenType.ASSIGNMENT, ETokenType.LPAREN, ETokenType.FLOATING_POINT_LITERAL, ETokenType.PLUS, ETokenType.FLOATING_POINT_LITERAL, ETokenType.RPAREN, ETokenType.PARAMETER_SEPARATOR, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.SEMICOLON);
    }

    public void testEndKeywordModification() throws IOException {
        this.assertTokens("end if;", ETokenType.END, ETokenType.ENDIF, ETokenType.SEMICOLON);
        this.assertTokens("end; if", ETokenType.END, ETokenType.SEMICOLON, ETokenType.IF);
        this.assertTokens("end --foo\n if", ETokenType.END, ETokenType.END_OF_LINE_COMMENT, ETokenType.ENDIF);
        this.assertTokens("end loop;", ETokenType.END, ETokenType.ENDLOOP, ETokenType.SEMICOLON);
        this.assertTokens("end; loop", ETokenType.END, ETokenType.SEMICOLON, ETokenType.LOOP);
        this.assertTokens("end --foo\n loop", ETokenType.END, ETokenType.END_OF_LINE_COMMENT, ETokenType.ENDLOOP);
        this.assertTokens("end case;", ETokenType.END, ETokenType.ENDCASE, ETokenType.SEMICOLON);
        this.assertTokens("end; case", ETokenType.END, ETokenType.SEMICOLON, ETokenType.CASE);
        this.assertTokens("end --foo\n case", ETokenType.END, ETokenType.END_OF_LINE_COMMENT, ETokenType.ENDCASE);
        this.assertTokens("end record;", ETokenType.END, ETokenType.ENDRECORD, ETokenType.SEMICOLON);
        this.assertTokens("end; record", ETokenType.END, ETokenType.SEMICOLON, ETokenType.RECORD);
        this.assertTokens("end --foo\n record", ETokenType.END, ETokenType.END_OF_LINE_COMMENT, ETokenType.ENDRECORD);
        this.assertTokens("end select;", ETokenType.END, ETokenType.ENDSELECT, ETokenType.SEMICOLON);
        this.assertTokens("end; select", ETokenType.END, ETokenType.SEMICOLON, ETokenType.SELECT);
        this.assertTokens("end --foo\n select", ETokenType.END, ETokenType.END_OF_LINE_COMMENT, ETokenType.ENDSELECT);
    }

    public void testSingleQuotes() throws IOException {
        this.assertTokens("foo'('0')", ETokenType.IDENTIFIER, ETokenType.SINGLE_QUOTE, ETokenType.LPAREN, ETokenType.CHARACTER_LITERAL, ETokenType.RPAREN);
    }
}

