/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class CobolScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.COBOL;
    }

    public void testErrorCases() {
    }

    public void testIntegerLiteral() throws IOException {
        this.assertToken("1", ETokenType.INTEGER_LITERAL);
        this.assertToken("13425", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatLiteral() throws IOException {
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("001.23E+04", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testHexIntegerLiteral() throws IOException {
        this.assertToken("X'ABCDEF'", ETokenType.INTEGER_LITERAL);
    }

    public void testSimpleStringLiteral() throws IOException {
        this.assertToken("'test '", ETokenType.STRING_LITERAL);
        this.assertToken("'?'", ETokenType.STRING_LITERAL);
        this.assertToken("'%'", ETokenType.STRING_LITERAL);
        this.assertToken("'\t/-!?%'", ETokenType.STRING_LITERAL);
        this.assertToken("'asdf?'", ETokenType.STRING_LITERAL);
        this.assertToken("'dsf   \n", ETokenType.STRING_LITERAL);
        this.assertToken("'dsf   \r", ETokenType.STRING_LITERAL);
        this.assertToken("'dsf   \r\n", ETokenType.STRING_LITERAL);
        this.assertTokens("'a' 'b'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL);
        this.assertTokens("'BMCP01: SACH-NR BLANK ODER FEHLT\n'asdf?'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL);
        this.assertTokens("'BMCP01: SACH-NR BLANK ODER FEHLT\r\n'asdf?'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL);
        this.assertTokens("'BMCP01: SACH-NR BLANK ODER FEHLT\r'asdf?'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL);
    }

    public void testComment() throws IOException {
        this.assertToken("      * Here goes the comment\n", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("      * Here goes the comment with character \u00e4 ... \n", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("      / Commentary\r\n", ETokenType.TRADITIONAL_COMMENT);
    }

    public void testIdentifier() throws IOException {
        this.assertToken("Identifier", ETokenType.IDENTIFIER);
    }

    public void testCompoundIdentifier() throws IOException {
        this.assertTokens("Compound-Identifier +", ETokenType.IDENTIFIER, ETokenType.PLUS);
        this.assertTokens("Compound-Identifier-53 +", ETokenType.IDENTIFIER, ETokenType.PLUS);
    }

    public void testOperator() throws IOException {
        this.assertToken("^=", ETokenType.NOTEQ);
        this.assertToken("^ =", ETokenType.NOTEQ);
    }

    public void testExcl() throws IOException {
        this.assertTokens("a !! b", ETokenType.IDENTIFIER, ETokenType.EXCLAMATION, ETokenType.EXCLAMATION, ETokenType.IDENTIFIER);
    }

    public void testUnknownCharacter() throws IOException {
        this.assertTokens("a % b ^= c ~", ETokenType.IDENTIFIER, ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.NOTEQ, ETokenType.IDENTIFIER, ETokenType.ILLEGAL_CHARACTER);
    }
}

