/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.EnumSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.ScannerFactory;

public class ETokenTypeTest
extends CCSMTestCaseBase {
    private static final File GENERATED_SRC_DIR = new File("generated-src");

    public void testEnumSize() {
        ETokenTypeTest.assertTrue((ETokenType.values().length < 2000 ? 1 : 0) != 0);
    }

    public void testUnusedTokenTypes() throws IOException {
        EnumSet<ETokenType> tokenTypes = EnumSet.allOf(ETokenType.class);
        tokenTypes.remove((Object)ETokenType.SENTINEL);
        StringBuilder scannerSourceCode = new StringBuilder();
        for (ELanguage language : ELanguage.values()) {
            scannerSourceCode.append(this.getScannerSourceCode(language));
        }
        for (ETokenType tokenType : tokenTypes) {
            ETokenTypeTest.assertTrue((String)("Token type " + (Object)((Object)tokenType) + " not found"), (scannerSourceCode.indexOf(tokenType.name()) > 0 ? 1 : 0) != 0);
        }
    }

    private String getScannerSourceCode(ELanguage language) throws IOException {
        ILenientScanner scanner = ScannerFactory.newLenientScanner(language, new StringReader(""), null);
        String filename = scanner.getClass().getName().replace('.', File.separatorChar) + ".java";
        return FileSystemUtils.readFile(new File(GENERATED_SRC_DIR, filename));
    }
}

