/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.util.List;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerTestBase;

public class PL1ScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.PL1;
    }

    public void testErrorCases() {
    }

    public void testIntegerLiteral() throws IOException {
        this.assertToken("0", ETokenType.INTEGER_LITERAL);
        this.assertToken("1", ETokenType.INTEGER_LITERAL);
        this.assertToken("78_123_234", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatLiteral() throws IOException {
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("001.23E+04", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBoolLiteral() throws IOException {
        this.assertToken("'0'B", ETokenType.BOOLEAN_LITERAL);
        this.assertToken("'1'B", ETokenType.BOOLEAN_LITERAL);
    }

    public void testSimpleStringLiteral() throws IOException {
        this.assertToken("\"test\"", ETokenType.STRING_LITERAL);
        this.assertToken("'test'", ETokenType.STRING_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertToken("// test", ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("/* test */", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("/*  * test ****/", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("/* test []}{?\u0000df\u0000fc\u0000d6\u0000e4u */", ETokenType.TRADITIONAL_COMMENT);
        this.assertTokens("/* test */  /* test2 */", ETokenType.TRADITIONAL_COMMENT, ETokenType.TRADITIONAL_COMMENT);
        this.assertTokens("/* test */ \r\n  /* test2 */", ETokenType.TRADITIONAL_COMMENT, ETokenType.TRADITIONAL_COMMENT);
    }

    public void testFailingComment() throws Exception {
        this.assertToken("/**  test */", ETokenType.TRADITIONAL_COMMENT);
    }

    public void testIllegalUnterminatedStringLiteral() throws IOException {
        String testString = "'test\ntest1";
        PL1ScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testWhitespaceNormalizedAway() throws Exception {
        List<IToken> tokens1 = this.getTokensFor(this.useTestFile("quicksort.pli"));
        List<IToken> tokens2 = this.getTokensFor(this.useTestFile("quicksort_different_whitespace.pli"));
        PL1ScannerTest.assertEquals((int)tokens1.size(), (int)tokens2.size());
        for (int i = 0; i < tokens1.size(); ++i) {
            PL1ScannerTest.assertEquals((String)tokens1.get(i).getText(), (String)tokens2.get(i).getText());
            PL1ScannerTest.assertEquals((Object)((Object)tokens1.get(i).getType()), (Object)((Object)tokens2.get(i).getType()));
        }
    }
}

