/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;
import org.conqat.lib.scanner.ScannerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScannerTestBase
extends CCSMTestCaseBase {
    public static final String[] LINE_TERMINATORS = new String[]{"\r", "\n", "\r\n"};

    public abstract void testErrorCases() throws IOException;

    public void testIllegalCharacter() throws IOException {
        String s = "\u00b2 identifier";
        this.assertTokens(s, ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.EOF);
    }

    public void testAssertLineNumbers() throws Exception {
        ILenientScanner scanner = this.getScannerFor("a" + StringUtils.CR + StringUtils.CR + "b");
        this.assertTokenLineNumbers(scanner);
    }

    public void testAssertLineNumbersCorrectWhenFormFeedsArePresent() throws Exception {
        ILenientScanner scanner = this.getScannerFor("a" + StringUtils.CR + "\f" + StringUtils.CR + "b");
        this.assertTokenLineNumbers(scanner);
    }

    protected void assertTokenLineNumbers(IScanner scanner) throws IOException, ScannerException {
        IToken token = scanner.getNextToken();
        ScannerTestBase.assertEquals((int)0, (int)token.getLineNumber());
        while (this.isEolToken(token = scanner.getNextToken())) {
        }
        ScannerTestBase.assertEquals((int)2, (int)token.getLineNumber());
    }

    private boolean isEolToken(IToken token) {
        return token.getType() == ETokenType.EOL || token.getType() == ETokenType.MULTIPLE_EOL;
    }

    protected boolean findProblem(String testString) throws IOException {
        IScanner scanner = ScannerFactory.newScanner(this.getLanguage(), testString, null);
        try {
            IToken token;
            while ((token = scanner.getNextToken()).getType() != ETokenType.EOF) {
                if (!token.getType().isError()) continue;
                return true;
            }
        }
        catch (ScannerException e) {
            return true;
        }
        return false;
    }

    protected void batchAssertTokenType(String[] tokenStrings, ETokenType expectedTokenType) throws IOException {
        for (String tokenString : tokenStrings) {
            this.assertToken(tokenString, expectedTokenType);
        }
    }

    protected void assertToken(String text, ETokenType type) throws IOException {
        IToken token = this.firstTokenFor(text);
        ScannerTestBase.assertEquals((String)("Type mismatch for '" + text + "'"), (Object)((Object)type), (Object)((Object)token.getType()));
        ScannerTestBase.assertEquals((String)("Text mismatch '" + text + "'"), (String)text, (String)token.getText());
    }

    protected IToken firstTokenFor(String text) throws IOException {
        ILenientScanner scanner = this.getScannerFor(text);
        return scanner.getNextToken();
    }

    protected ILenientScanner getScannerFor(String text) {
        return ScannerFactory.newLenientScanner(this.getLanguage(), new StringReader(text), null);
    }

    protected ILenientScanner getScannerFor(File file) throws IOException {
        return ScannerFactory.newLenientScanner(this.getLanguage(), file);
    }

    protected List<IToken> getTokensFor(File file) throws IOException {
        return ScannerUtils.readTokens(this.getScannerFor(file));
    }

    protected abstract ELanguage getLanguage();

    protected void assertTokens(String text, ETokenType ... types) throws IOException {
        ILenientScanner scanner = this.getScannerFor(text);
        for (ETokenType type : types) {
            IToken token = scanner.getNextToken();
            ScannerTestBase.assertEquals((String)("Type mismatch in text:" + text), (Object)((Object)type), (Object)((Object)token.getType()));
        }
        ScannerTestBase.assertEquals((String)("More tokens found than expected token types specified in text" + text), (Object)((Object)ETokenType.EOF), (Object)((Object)scanner.getNextToken().getType()));
    }

    protected void assertTokenOffset(IToken token, ETokenType expectedTokenType, int expectedOffset) {
        ScannerTestBase.assertEquals((Object)((Object)expectedTokenType), (Object)((Object)token.getType()));
        ScannerTestBase.assertEquals((int)expectedOffset, (int)token.getOffset());
    }
}

