/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;
import org.conqat.lib.scanner.ScannerUtils;

public class ScannerUtilsTest
extends TestCase {
    private static String TEST1 = "int a; int b;";
    private static String TEST2 = "int a; int #b; int c;";
    private static String TEST3 = "int a; int #b; int #c;";
    private static String TEST4 = "int a; int #";
    private static String TEST5 = "int a; int # #";
    private static String TEST6 = "#";

    public void testReadTokensWithProperInput() throws IOException {
        IScanner scanner = ScannerFactory.newScanner(ELanguage.JAVA, TEST1, null);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)6, (int)tokens.size());
        ScannerUtilsTest.assertTrue((boolean)exceptions.isEmpty());
    }

    public void testReadTokensWithOneIllegalToken() throws IOException {
        IScanner scanner = this.createScanner(TEST2);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)9, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)1, (int)exceptions.size());
    }

    private IScanner createScanner(String s) {
        return ScannerFactory.newScanner(ELanguage.JAVA, s, null);
    }

    public void testReadTokensWithTwoIllegalToken() throws IOException {
        IScanner scanner = this.createScanner(TEST3);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)9, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)2, (int)exceptions.size());
    }

    public void testReadTokensWithIllegalTokenAtEnd() throws IOException {
        IScanner scanner = this.createScanner(TEST4);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)4, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)1, (int)exceptions.size());
    }

    public void testReadTokensWithTwoIllegalTokensAtEnd() throws IOException {
        IScanner scanner = this.createScanner(TEST5);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)4, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)2, (int)exceptions.size());
    }

    public void testReadTokensWithIllegalTokensOnly() throws IOException {
        IScanner scanner = this.createScanner(TEST6);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)0, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)1, (int)exceptions.size());
    }

    public void testReadTokensFromEmptyFile() throws IOException {
        for (ELanguage language : ELanguage.values()) {
            if (language != ELanguage.JAVA) continue;
            this.readFromEmptyInput();
        }
    }

    private void readFromEmptyInput() throws IOException {
        IScanner scanner = this.createScanner("");
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        ArrayList<ScannerException> exceptions = new ArrayList<ScannerException>();
        ScannerUtils.readTokens(scanner, tokens, exceptions);
        ScannerUtilsTest.assertEquals((int)0, (int)tokens.size());
        ScannerUtilsTest.assertEquals((int)0, (int)exceptions.size());
    }
}

