/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.SQLScannerTestBase;

public class TSQLScannerTest
extends SQLScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.TSQL;
    }

    public void testEOL() throws IOException {
        this.batchAssertTokenType(LINE_TERMINATORS, ETokenType.EOL);
        for (String terminator : LINE_TERMINATORS) {
            this.assertTokens("abc" + terminator + "xyz", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        }
    }

    public void testIdentifiersTsql() throws IOException {
        String[] bracketQuoted = new String[]{"[X+Y]", "[last name]", "[on/off switch]", "[employee(s)]", "[*** header info ***]"};
        this.batchAssertTokenType(bracketQuoted, ETokenType.IDENTIFIER);
        String[] specialCharAtBegin = new String[]{"_", "@", "#", "_a", "_lastName", "@lastName", "#@_lastName@@$"};
        this.batchAssertTokenType(specialCharAtBegin, ETokenType.IDENTIFIER);
        this.assertToken("$(DBName)", ETokenType.IDENTIFIER);
    }

    public void testKeywordsTsql() throws IOException {
        this.assertToken("ADD", ETokenType.ADD);
        this.assertToken("AUTHORIZATION", ETokenType.AUTHORIZATION);
        this.assertToken("BACKUP", ETokenType.BACKUP);
        this.assertToken("BREAK", ETokenType.BREAK);
        this.assertToken("BROWSE", ETokenType.BROWSE);
        this.assertToken("BULK", ETokenType.BULK);
        this.assertToken("CASCADE", ETokenType.CASCADE);
        this.assertToken("CATCH", ETokenType.CATCH);
        this.assertToken("CHECKPOINT", ETokenType.CHECKPOINT);
        this.assertToken("CLOSE", ETokenType.CLOSE);
        this.assertToken("CLUSTERED", ETokenType.CLUSTERED);
        this.assertToken("COALESCE", ETokenType.COALESCE);
        this.assertToken("COLLATE", ETokenType.COLLATE);
        this.assertToken("COLUMN", ETokenType.COLUMN);
        this.assertToken("COMMIT", ETokenType.COMMIT);
        this.assertToken("COMPUTE", ETokenType.COMPUTE);
        this.assertToken("CONSTRAINT", ETokenType.CONSTRAINT);
        this.assertToken("CONTAINS", ETokenType.CONTAINS);
        this.assertToken("CONTAINSTABLE", ETokenType.CONTAINSTABLE);
        this.assertToken("CONTINUE", ETokenType.CONTINUE);
        this.assertToken("CONVERT", ETokenType.CONVERT);
        this.assertToken("CROSS", ETokenType.CROSS);
        this.assertToken("CURRENT_DATE", ETokenType.CURRENT_DATE);
        this.assertToken("CURRENT_TIME", ETokenType.CURRENT_TIME);
        this.assertToken("CURRENT_TIMESTAMP", ETokenType.CURRENT_TIMESTAMP);
        this.assertToken("CURRENT_USER", ETokenType.CURRENT_USER);
        this.assertToken("CURSOR", ETokenType.CURSOR);
        this.assertToken("DATABASE", ETokenType.DATABASE);
        this.assertToken("DBCC", ETokenType.DBCC);
        this.assertToken("DEALLOCATE", ETokenType.DEALLOCATE);
        this.assertToken("DENY", ETokenType.DENY);
        this.assertToken("DISK", ETokenType.DISK);
        this.assertToken("DISTRIBUTED", ETokenType.DISTRIBUTED);
        this.assertToken("DOUBLE", ETokenType.DOUBLE);
        this.assertToken("DUMP", ETokenType.DUMP);
        this.assertToken("ERRLVL", ETokenType.ERRLVL);
        this.assertToken("ESCAPE", ETokenType.ESCAPE);
        this.assertToken("EXCEPT", ETokenType.EXCEPT);
        this.assertToken("EXEC", ETokenType.EXEC);
        this.assertToken("EXECUTE", ETokenType.EXECUTE);
        this.assertToken("EXIT", ETokenType.EXIT);
        this.assertToken("EXTERNAL", ETokenType.EXTERNAL);
        this.assertToken("FILE", ETokenType.FILE);
        this.assertToken("FILLFACTOR", ETokenType.FILLFACTOR);
        this.assertToken("FOREIGN", ETokenType.FOREIGN);
        this.assertToken("FREETEXT", ETokenType.FREETEXT);
        this.assertToken("FREETEXTTABLE", ETokenType.FREETEXTTABLE);
        this.assertToken("FULL", ETokenType.FULL);
        this.assertToken("FUNCTION", ETokenType.FUNCTION);
        this.assertToken("HOLDLOCK", ETokenType.HOLDLOCK);
        this.assertToken("IDENTITY", ETokenType.IDENTITY);
        this.assertToken("IDENTITY_INSERT", ETokenType.IDENTITY_INSERT);
        this.assertToken("IDENTITYCOL", ETokenType.IDENTITYCOL);
        this.assertToken("INNER", ETokenType.INNER);
        this.assertToken("JOIN", ETokenType.JOIN);
        this.assertToken("KEY", ETokenType.KEY);
        this.assertToken("KILL", ETokenType.KILL);
        this.assertToken("LEFT", ETokenType.LEFT);
        this.assertToken("LINENO", ETokenType.LINENO);
        this.assertToken("LOAD", ETokenType.LOAD);
        this.assertToken("MERGE", ETokenType.MERGE);
        this.assertToken("NATIONAL", ETokenType.NATIONAL);
        this.assertToken("NOCHECK", ETokenType.NOCHECK);
        this.assertToken("NONCLUSTERED", ETokenType.NONCLUSTERED);
        this.assertToken("NULL", ETokenType.NULL);
        this.assertToken("NULLIF", ETokenType.NULLIF);
        this.assertToken("OFF", ETokenType.OFF);
        this.assertToken("OFFSETS", ETokenType.OFFSETS);
        this.assertToken("OPEN", ETokenType.OPEN);
        this.assertToken("OPENDATASOURCE", ETokenType.OPENDATASOURCE);
        this.assertToken("OPENQUERY", ETokenType.OPENQUERY);
        this.assertToken("OPENROWSET", ETokenType.OPENROWSET);
        this.assertToken("OPENXML", ETokenType.OPENXML);
        this.assertToken("OUTER", ETokenType.OUTER);
        this.assertToken("OVER", ETokenType.OVER);
        this.assertToken("PERCENT", ETokenType.PERCENT);
        this.assertToken("PIVOT", ETokenType.PIVOT);
        this.assertToken("PLAN", ETokenType.PLAN);
        this.assertToken("PRECISION", ETokenType.PRECISION);
        this.assertToken("PRIMARY", ETokenType.PRIMARY);
        this.assertToken("PRINT", ETokenType.PRINT);
        this.assertToken("PROC", ETokenType.PROC);
        this.assertToken("RAISERROR", ETokenType.RAISERROR);
        this.assertToken("READ", ETokenType.READ);
        this.assertToken("READTEXT", ETokenType.READTEXT);
        this.assertToken("RECONFIGURE", ETokenType.RECONFIGURE);
        this.assertToken("REFERENCES", ETokenType.REFERENCES);
        this.assertToken("REPLICATION", ETokenType.REPLICATION);
        this.assertToken("RESTORE", ETokenType.RESTORE);
        this.assertToken("RESTRICT", ETokenType.RESTRICT);
        this.assertToken("RETURN", ETokenType.RETURN);
        this.assertToken("REVERT", ETokenType.REVERT);
        this.assertToken("RIGHT", ETokenType.RIGHT);
        this.assertToken("ROLLBACK", ETokenType.ROLLBACK);
        this.assertToken("ROWCOUNT", ETokenType.ROWCOUNT);
        this.assertToken("ROWGUIDCOL", ETokenType.ROWGUIDCOL);
        this.assertToken("RULE", ETokenType.RULE);
        this.assertToken("SAVE", ETokenType.SAVE);
        this.assertToken("SCHEMA", ETokenType.SCHEMA);
        this.assertToken("SECURITYAUDIT", ETokenType.SECURITYAUDIT);
        this.assertToken("SESSION_USER", ETokenType.SESSION_USER);
        this.assertToken("SET", ETokenType.SET);
        this.assertToken("SETUSER", ETokenType.SETUSER);
        this.assertToken("SHUTDOWN", ETokenType.SHUTDOWN);
        this.assertToken("SOME", ETokenType.SOME);
        this.assertToken("STATISTICS", ETokenType.STATISTICS);
        this.assertToken("SYSTEM_USER", ETokenType.SYSTEM_USER);
        this.assertToken("TABLESAMPLE", ETokenType.TABLESAMPLE);
        this.assertToken("TEXTSIZE", ETokenType.TEXTSIZE);
        this.assertToken("TOP", ETokenType.TOP);
        this.assertToken("TRAN", ETokenType.TRAN);
        this.assertToken("TRANSACTION", ETokenType.TRANSACTION);
        this.assertToken("TRIGGER", ETokenType.TRIGGER);
        this.assertToken("TRUNCATE", ETokenType.TRUNCATE);
        this.assertToken("TRY", ETokenType.TRY);
        this.assertToken("TSEQUAL", ETokenType.TSEQUAL);
        this.assertToken("UNPIVOT", ETokenType.UNPIVOT);
        this.assertToken("UPDATETEXT", ETokenType.UPDATETEXT);
        this.assertToken("USE", ETokenType.USE);
        this.assertToken("USER", ETokenType.USER);
        this.assertToken("VARYING", ETokenType.VARYING);
        this.assertToken("WAITFOR", ETokenType.WAITFOR);
        this.assertToken("WHILE", ETokenType.WHILE);
        this.assertToken("WRITETEXT", ETokenType.WRITETEXT);
    }

    public void testOperatorsTsql() throws IOException {
        this.assertToken("%", ETokenType.MOD);
        this.assertToken("::", ETokenType.DOUBLE_COLON);
        this.assertToken("&", ETokenType.AND);
        this.assertToken("|", ETokenType.OR);
        this.assertToken("^", ETokenType.XOR);
        this.assertToken("~", ETokenType.NOT);
        this.assertToken("!<", ETokenType.NLT);
        this.assertToken("!>", ETokenType.NGT);
        this.assertToken("+=", ETokenType.PLUSEQ);
        this.assertToken("-=", ETokenType.MINUSEQ);
        this.assertToken("*=", ETokenType.MULTEQ);
        this.assertToken("%=", ETokenType.MODEQ);
        this.assertToken("&=", ETokenType.ANDEQ);
        this.assertToken("|=", ETokenType.OREQ);
        this.assertToken("^=", ETokenType.XOREQ);
        this.assertToken("/=", ETokenType.DIVEQ);
    }

    public void testSpecialStringLiterals() throws IOException {
        this.assertToken("'abc''xyz'", ETokenType.STRING_LITERAL);
        this.assertTokens("'abc' 'xyz'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL);
        this.assertToken("N'this is a string'", ETokenType.STRING_LITERAL);
        this.assertToken("''", ETokenType.STRING_LITERAL);
        this.assertTokens("test '' test", ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER);
    }

    public void testBinaryLiterals() throws IOException {
        this.assertToken("0xAE", ETokenType.BINARY_LITERAL);
        this.assertToken("0x12Ef", ETokenType.BINARY_LITERAL);
        this.assertToken("0x69048AEFDD010E", ETokenType.BINARY_LITERAL);
        this.assertToken("0x", ETokenType.BINARY_LITERAL);
    }

    public void testMoneyLiterals() throws IOException {
        this.assertToken("$12", ETokenType.MONEY_LITERAL);
        this.assertToken("$542023.14", ETokenType.MONEY_LITERAL);
        this.assertToken("-$12", ETokenType.MONEY_LITERAL);
        this.assertToken("-$542023.14", ETokenType.MONEY_LITERAL);
        this.assertToken("+$12", ETokenType.MONEY_LITERAL);
        this.assertToken("+$542023.14", ETokenType.MONEY_LITERAL);
    }
}

