/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ScannerTestBase;
import org.conqat.lib.scanner.TabReplacingReader;

public class TabReplacingReaderTest
extends TestCase {
    public void testSingleLine() throws IOException {
        for (int i = 0; i <= 16; ++i) {
            this.assertSingleLine(i);
        }
    }

    public void testMultiLine() throws IOException {
        String[] expected = this.multi(this.spaces(8) + "abc", this.spaces(8) + "abc");
        String[] input = this.multi("\tabc", "\tabc");
        this.assertMultiLine(expected, input);
        expected = this.multi("", this.spaces(8) + "abc");
        input = this.multi("", "\tabc");
        this.assertMultiLine(expected, input);
        expected = this.multi(this.spaces(8) + "abc", this.spaces(8) + "abc");
        input = this.multi(this.spaces(3) + "\tabc", this.spaces(2) + "\tabc");
        this.assertMultiLine(expected, input);
        expected = this.multi(this.spaces(8) + "abc", "xyz", this.spaces(8) + "abc");
        input = this.multi(this.spaces(3) + "\tabc", "xyz", this.spaces(2) + "\tabc");
        this.assertMultiLine(expected, input);
        expected = this.multi(this.spaces(8) + "abc", "", this.spaces(8) + "abc");
        input = this.multi(this.spaces(3) + "\tabc", "", this.spaces(2) + "\tabc");
        this.assertMultiLine(expected, input);
    }

    private void assertMultiLine(String[] expectedLines, String[] inputLines) throws IOException {
        for (String terminator : ScannerTestBase.LINE_TERMINATORS) {
            String input = StringUtils.concat((Object[])inputLines, terminator);
            String expected = StringUtils.concat((Object[])expectedLines, terminator);
            this.assertTabReplacement(expected, input);
        }
    }

    public void testSpecialCases() throws IOException {
        this.assertTabReplacement("", "");
        this.assertTabReplacement(" ", " ");
        this.assertTabReplacement(this.spaces(8), "\t");
        this.assertTabReplacement(this.spaces(8) + StringUtils.CR + "abc", "\t" + StringUtils.CR + "abc");
        this.assertTabReplacement(this.spaces(8) + StringUtils.CR + this.spaces(8) + "abc", "\t" + StringUtils.CR + "\tabc");
    }

    public void testUnchangedRemainder() throws IOException {
        this.assertTabReplacement("abc\t", "abc\t");
        this.assertTabReplacement("abc\tabc", "abc\tabc");
        this.assertTabReplacement("abc \t abc", "abc \t abc");
        this.assertTabReplacement("abc \tabc", "abc \tabc");
        this.assertTabReplacement(this.spaces(8) + "abc\t", "\tabc\t");
        this.assertTabReplacement(this.spaces(8) + "abc\tabc", "\tabc\tabc");
        this.assertTabReplacement(this.spaces(8) + "abc \t abc", "\tabc \t abc");
        this.assertTabReplacement(this.spaces(8) + "abc \tabc", "\tabc \tabc");
    }

    private void assertSingleLine(int tabLength) throws IOException {
        for (int i = 0; i < tabLength; ++i) {
            this.assertTabReplacement(this.spaces(tabLength) + "abc", this.spaces(i) + "\tabc", tabLength);
            this.assertTabReplacement(this.spaces(tabLength * 2) + "abc", this.spaces(i) + "\t" + this.spaces(i) + "\tabc", tabLength);
        }
    }

    private void assertTabReplacement(String expected, String input) throws IOException {
        this.assertTabReplacement(expected, input, 8);
    }

    private void assertTabReplacement(String expected, String input, int tabLength) throws IOException {
        int n;
        TabReplacingReader reader = new TabReplacingReader(new StringReader(input), tabLength);
        StringBuilder actual = new StringBuilder();
        while ((n = reader.read()) != -1) {
            actual.append((char)n);
        }
        TabReplacingReaderTest.assertEquals((String)expected, (String)actual.toString());
    }

    private String spaces(int length) {
        return StringUtils.fillString(length, ' ');
    }

    private String[] multi(String ... lines) {
        return lines;
    }
}

