/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class TextScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.TEXT;
    }

    public void testWords() throws IOException {
        this.assertToken("hallo", ETokenType.WORD);
        this.assertToken("Schlumpf0815", ETokenType.WORD);
        this.assertTokens("This sentence contains 5 words", ETokenType.WORD, ETokenType.WORD, ETokenType.WORD, ETokenType.WORD, ETokenType.WORD);
    }

    public void testPunctuation() throws IOException {
        this.assertToken(".", ETokenType.DOT);
        this.assertToken("!", ETokenType.EXCLAMATION);
        this.assertToken("?", ETokenType.QUESTION);
        this.assertTokens(".!?!.", ETokenType.DOT, ETokenType.EXCLAMATION, ETokenType.QUESTION, ETokenType.EXCLAMATION, ETokenType.DOT);
    }

    public void testSentence() throws IOException {
        this.assertTokens("Start. and some more?", ETokenType.WORD, ETokenType.DOT, ETokenType.WORD, ETokenType.WORD, ETokenType.WORD, ETokenType.QUESTION);
    }

    public void testMinus() throws IOException {
        this.assertTokens("+*\u00a7-", ETokenType.EOF);
        this.assertTokens("+*\u00a7- Word", ETokenType.WORD, ETokenType.EOF);
    }

    public void testMultipleLineBreaks() throws Exception {
        this.assertTokens("hallo\nhallo", ETokenType.WORD, ETokenType.WORD);
        this.assertTokens("hallo\r\nhallo", ETokenType.WORD, ETokenType.WORD);
        this.assertTokens("hallo\n\nhallo", ETokenType.WORD, ETokenType.MULTIPLE_EOL, ETokenType.WORD);
        this.assertTokens("hallo\n \nhallo", ETokenType.WORD, ETokenType.MULTIPLE_EOL, ETokenType.WORD);
        this.assertTokens("hallo\n \r\n\r\n \n\r \nhallo", ETokenType.WORD, ETokenType.MULTIPLE_EOL, ETokenType.WORD);
    }

    public void testUmlaute() throws IOException {
        String umlauts = "J\u00fcrgens Dei\u00dfenb\u00f6ck";
        this.assertTokens(umlauts, ETokenType.WORD, ETokenType.WORD, ETokenType.EOF);
    }

    public void testErrorCases() {
    }

    public void testIllegalCharacter() {
    }
}

