/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner.highlighting;

import java.awt.Color;
import java.util.List;
import org.conqat.lib.commons.cache4j.BasicCache;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IParameterizedFactory;
import org.conqat.lib.commons.html.CSSDeclarationBlock;
import org.conqat.lib.commons.html.ECSSProperty;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerUtils;
import org.conqat.lib.scanner.highlighting.SourceCodeStyle;

public class SourceCodeHtmlFormatter {
    private final ICache<ImmutablePair<Color, Integer>, CSSDeclarationBlock, NeverThrownRuntimeException> cssCache = new BasicCache<ImmutablePair<Color, Integer>, CSSDeclarationBlock, NeverThrownRuntimeException>(null, new CSSStyleFactory(), ECachingStrategy.UNLIMITED.getBackend(0));
    private CSSDeclarationBlock baseStyle;
    private CSSDeclarationBlock lineStyle;
    private CSSDeclarationBlock lineNumberStyle;
    protected HTMLWriter writer;
    private String content;
    private List<IToken> tokens;
    private SourceCodeStyle style;
    private int tokenIndex;
    private int characterPosition;

    public void formatSourceCode(String content, ELanguage language, HTMLWriter writer) {
        if (this.baseStyle == null) {
            this.init();
        }
        this.content = StringUtils.replaceLineBreaks(content, "\n");
        this.tokens = ScannerUtils.getTokens(content, language);
        this.writer = writer;
        this.style = SourceCodeStyle.get(language);
        this.tokenIndex = 0;
        this.characterPosition = 0;
        this.format();
    }

    protected void format() {
        this.writer.setSuppressLineBreaks(true);
        String[] lines = StringUtils.splitLines(this.content);
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            this.formatLine(lines[lineIndex], lineIndex + 1);
        }
        this.writer.setSuppressLineBreaks(false);
    }

    protected void formatLine(String line, int lineNumber) {
        this.writer.openElement(EHTMLElement.DIV, new Object[]{EHTMLAttribute.CLASS, this.lineStyle});
        this.formatLineNumber(lineNumber);
        this.insertLineNumberSpacer(lineNumber);
        this.formatLineContent(line, lineNumber);
        this.writer.closeElement(EHTMLElement.DIV);
        this.writer.addNewLine();
        ++this.characterPosition;
    }

    protected void insertLineNumberSpacer(int lineNumber) {
    }

    private void formatLineNumber(int lineNumber) {
        this.writer.addClosedTextElement(EHTMLElement.SPAN, this.formatLineNumberString(lineNumber), new Object[]{EHTMLAttribute.CLASS, this.lineNumberStyle});
    }

    protected String formatLineNumberString(int lineNumber) {
        return String.format("%5d: ", lineNumber);
    }

    protected void formatLineContent(String line, int lineNumber) {
        CSSDeclarationBlock currentCSS = null;
        IToken currentToken = null;
        for (int i = 0; i < line.length(); ++i) {
            if (currentToken == null || this.characterPosition > currentToken.getEndOffset()) {
                CSSDeclarationBlock expectedCSS = null;
                while (this.tokenIndex < this.tokens.size() && this.tokens.get(this.tokenIndex).getEndOffset() < this.characterPosition) {
                    ++this.tokenIndex;
                }
                if (this.tokenIndex < this.tokens.size() && this.characterPosition >= this.tokens.get(this.tokenIndex).getOffset()) {
                    currentToken = this.tokens.get(this.tokenIndex);
                    expectedCSS = this.determineCSS(currentToken.getType());
                }
                this.switchCSS(currentCSS, expectedCSS);
                currentCSS = expectedCSS;
            }
            this.insertCharacter(line.charAt(i));
            ++this.characterPosition;
        }
        this.switchCSS(currentCSS, null);
    }

    private void insertCharacter(char c) {
        switch (c) {
            case '&': {
                this.writer.addRawString("&amp;");
                break;
            }
            case '<': {
                this.writer.addRawString("&lt;");
                break;
            }
            case '>': {
                this.writer.addRawString("&gt;");
                break;
            }
            case '\"': {
                this.writer.addRawString("&quot;");
                break;
            }
            default: {
                this.writer.addRawString(Character.toString(c));
            }
        }
    }

    protected void switchCSS(CSSDeclarationBlock current, CSSDeclarationBlock next) {
        if (current == next) {
            return;
        }
        if (current != null) {
            this.writer.closeElement(EHTMLElement.SPAN);
        }
        if (next != null) {
            this.writer.openElement(EHTMLElement.SPAN, new Object[]{EHTMLAttribute.CLASS, next});
        }
    }

    protected CSSDeclarationBlock determineCSS(ETokenType type) {
        return this.cssCache.obtain(this.style.getStyle(type));
    }

    protected void init() {
        this.baseStyle = this.createBaseStyle();
        this.lineStyle = this.createLineStyle(this.baseStyle);
        this.lineNumberStyle = this.createLineNumberStyle(this.baseStyle);
    }

    protected CSSDeclarationBlock createBaseStyle() {
        return new CSSDeclarationBlock(new Object[]{ECSSProperty.FONT_SIZE, "13px", ECSSProperty.WHITE_SPACE, "pre", ECSSProperty.FONT_FAMILY, "Monospace"});
    }

    protected CSSDeclarationBlock createLineStyle(CSSDeclarationBlock baseStyle) {
        return new CSSDeclarationBlock(baseStyle, new Object[]{ECSSProperty.MARGIN_BOTTOM, "0"});
    }

    protected CSSDeclarationBlock createLineNumberStyle(CSSDeclarationBlock baseStyle) {
        return new CSSDeclarationBlock(baseStyle, new Object[]{ECSSProperty.COLOR, "#aaaaaa"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CSSStyleFactory
    implements IParameterizedFactory<CSSDeclarationBlock, ImmutablePair<Color, Integer>, NeverThrownRuntimeException> {
        private CSSStyleFactory() {
        }

        @Override
        public CSSDeclarationBlock create(ImmutablePair<Color, Integer> style) {
            CSSDeclarationBlock css = new CSSDeclarationBlock(SourceCodeHtmlFormatter.this.baseStyle, new Object[0]);
            css.setProperty(ECSSProperty.COLOR, ColorUtils.toHtmlString(style.getFirst()));
            if ((style.getSecond() & 1) != 0) {
                css.setProperty(ECSSProperty.FONT_WEIGHT, "bold");
            }
            if ((style.getSecond() & 2) != 0) {
                css.setProperty(ECSSProperty.FONT_STYLE, "italic");
            }
            return css;
        }
    }
}

