/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner.highlighting;

import java.awt.Color;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeStyle {
    private static final Color JAVA_COMMENT_COLOR = new Color(63, 127, 95);
    private static final Color JAVA_DOCCOMMENT_COLOR = new Color(63, 95, 191);
    private static final Color JAVA_KEYWORD_COLOR = new Color(127, 0, 85);
    private static final Color JAVA_LITERAL_COLOR = new Color(42, 0, 255);
    private static final Color CS_KEYWORD_COLOR = new Color(0, 0, 255);
    private static final Color CS_COMMENT_COLOR = new Color(0, 128, 0);
    private static final Color CS_LITERAL_COLOR = new Color(163, 21, 21);
    private static final Color CS_SPECIAL_COLOR = new Color(200, 200, 200);
    private static final Color CS_DOCCOMMENT_COLOR = new Color(128, 128, 128);
    private static SourceCodeStyle DEFAULT_STYLE = new SourceCodeStyle();
    private static SourceCodeStyle JAVA_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType) {
            if (tokenType == ETokenType.DOCUMENTATION_COMMENT) {
                return SourceCodeStyle.style(JAVA_DOCCOMMENT_COLOR);
            }
            return super.getStyle(tokenType);
        }
    };
    private static SourceCodeStyle PLSQL_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType) {
            if (tokenType.getTokenClass() == ETokenType.ETokenClass.OPERATOR) {
                return super.getStyle(ETokenType.IF);
            }
            return super.getStyle(tokenType);
        }
    };
    private static SourceCodeStyle CS_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType) {
            if (tokenType == ETokenType.DOCUMENTATION_COMMENT) {
                return SourceCodeStyle.style(CS_DOCCOMMENT_COLOR);
            }
            switch (tokenType.getTokenClass()) {
                case KEYWORD: {
                    return SourceCodeStyle.style(CS_KEYWORD_COLOR);
                }
                case LITERAL: {
                    return SourceCodeStyle.style(CS_LITERAL_COLOR);
                }
                case COMMENT: {
                    return SourceCodeStyle.style(CS_COMMENT_COLOR);
                }
                case SPECIAL: {
                    return SourceCodeStyle.style(CS_SPECIAL_COLOR);
                }
            }
            return super.getStyle(tokenType);
        }
    };
    private static SourceCodeStyle PLAIN_TEXT_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType) {
            return SourceCodeStyle.style(Color.BLACK);
        }
    };

    private SourceCodeStyle() {
    }

    public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType) {
        switch (tokenType.getTokenClass()) {
            case KEYWORD: {
                return SourceCodeStyle.style(JAVA_KEYWORD_COLOR, 1);
            }
            case LITERAL: {
                return SourceCodeStyle.style(JAVA_LITERAL_COLOR);
            }
            case SYNTHETIC: 
            case ERROR: {
                return SourceCodeStyle.style(Color.RED, 1);
            }
            case COMMENT: {
                return SourceCodeStyle.style(JAVA_COMMENT_COLOR);
            }
        }
        return SourceCodeStyle.style(Color.BLACK);
    }

    public ImmutablePair<Color, Integer> getStyle(IToken token) {
        return this.getStyle(token.getType());
    }

    private static ImmutablePair<Color, Integer> style(Color color) {
        return SourceCodeStyle.style(color, 0);
    }

    private static ImmutablePair<Color, Integer> style(Color color, int style) {
        return new ImmutablePair<Color, Integer>(color, style);
    }

    public static SourceCodeStyle get(ELanguage language) {
        switch (language) {
            case TEXT: {
                return PLAIN_TEXT_STYLE;
            }
            case JAVA: {
                return JAVA_STYLE;
            }
            case CS: 
            case VB: {
                return CS_STYLE;
            }
            case PLSQL: {
                return PLSQL_STYLE;
            }
        }
        return DEFAULT_STYLE;
    }
}

