/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableRow
extends Accessible {
    public AccessibleTableRow(Accessible accessible, int n) {
        super(accessible);
        this.index = n;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Object[] objectArray = new Object[n];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                int n2 = 0;
                while (n2 < n) {
                    accessibleTableEvent.column = n2;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    int n3 = 0;
                    while (n3 < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                        AccessibleTableListener accessibleTableListener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(n3);
                        accessibleTableListener.getCell(accessibleTableEvent);
                        ++n3;
                    }
                    if (accessibleTableEvent.accessible != null) {
                        accessibleTableEvent.accessible.parent = AccessibleTableRow.this;
                    }
                    objectArray[n2] = accessibleTableEvent.accessible;
                    ++n2;
                }
                accessibleControlEvent.children = objectArray;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Object object;
                NSObject nSObject;
                int n = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Accessible[] accessibleArray = new Accessible[n];
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                int n2 = 0;
                while (n2 < n) {
                    accessibleTableEvent.column = n2;
                    accessibleTableEvent.row = AccessibleTableRow.this.index;
                    int n3 = 0;
                    while (n3 < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                        AccessibleTableListener accessibleTableListener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(n3);
                        accessibleTableListener.getCell(accessibleTableEvent);
                        ++n3;
                    }
                    accessibleArray[n2] = accessibleTableEvent.accessible;
                    ++n2;
                }
                NSValue nSValue = (NSValue)accessibleArray[0].getPositionAttribute(-1);
                NSPoint nSPoint = nSValue.pointValue();
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (n6 < accessibleArray.length) {
                    nSObject = (NSValue)accessibleArray[n6].getSizeAttribute(-1);
                    object = ((NSValue)nSObject).sizeValue();
                    if (((NSSize)object).height > (float)n4) {
                        n4 = (int)((NSSize)object).height;
                    }
                    n5 = (int)((float)n5 + ((NSSize)object).width);
                    ++n6;
                }
                accessibleControlEvent.x = (int)nSPoint.x;
                NSArray nSArray = NSScreen.screens();
                nSObject = new NSScreen(nSArray.objectAtIndex(0));
                object = ((NSScreen)nSObject).frame();
                accessibleControlEvent.y = (int)(((NSRect)object).height - nSPoint.y - (float)n4);
                accessibleControlEvent.width = n5;
                accessibleControlEvent.height = n4;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = accessibleControlEvent.childID;
                accessibleControlEvent.detail = n == -1 ? 28 : 29;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                NSNumber nSNumber;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
                accessibleTableEvent.column = 0;
                accessibleTableEvent.row = AccessibleTableRow.this.index;
                int n = 0;
                while (n < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(n);
                    accessibleTableListener.getCell(accessibleTableEvent);
                    ++n;
                }
                accessibleControlEvent.childID = accessibleTableEvent.accessible != null ? ((nSNumber = (NSNumber)accessibleTableEvent.accessible.getFocusedAttribute(-1)).boolValue() ? -1 : -2) : -2;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void isColumnSelected(AccessibleTableEvent accessibleTableEvent) {
                accessibleTableEvent.isSelected = false;
            }

            public void isRowSelected(AccessibleTableEvent accessibleTableEvent) {
                AccessibleTableEvent accessibleTableEvent2 = new AccessibleTableEvent(this);
                accessibleTableEvent2.row = accessibleTableEvent.row;
                int n = 0;
                while (n < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)AccessibleTableRow.this.parent.accessibleTableListeners.elementAt(n);
                    accessibleTableListener.isRowSelected(accessibleTableEvent2);
                    ++n;
                }
                accessibleTableEvent.isSelected = accessibleTableEvent2.isSelected;
            }
        });
    }

    void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
        Object object;
        int n = Math.max(1, this.parent.getColumnCount());
        Accessible[] accessibleArray = new Accessible[n];
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < n) {
            accessibleTableEvent.column = n2;
            accessibleTableEvent.row = this.index;
            int n3 = 0;
            while (n3 < this.parent.accessibleTableListeners.size()) {
                object = (AccessibleTableListener)this.parent.accessibleTableListeners.elementAt(n3);
                object.getCell(accessibleTableEvent);
                ++n3;
            }
            accessibleArray[n2] = accessibleTableEvent.accessible;
            ++n2;
        }
        n2 = 0;
        while (n2 < accessibleArray.length) {
            NSValue nSValue = (NSValue)accessibleArray[n2].getPositionAttribute(this.index);
            object = nSValue.pointValue();
            NSValue nSValue2 = (NSValue)accessibleArray[n2].getSizeAttribute(this.index);
            NSSize nSSize = nSValue2.sizeValue();
            if (((NSPoint)object).x <= (float)accessibleControlEvent.x && (float)accessibleControlEvent.x <= ((NSPoint)object).x + nSSize.width) {
                accessibleArray[n2].parent = this;
                accessibleControlEvent.accessible = accessibleArray[n2];
                break;
            }
            ++n2;
        }
    }
}

