/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;
    int yCurrentScroll;

    public ExpandBar(Composite composite, int n) {
        super(composite, n);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (n != -1 && n < 0) {
                n = 0;
            }
            if (n2 != -1 && n2 < 0) {
                n2 = 0;
            }
            Point point = this.computeNativeSize(this.handle, n, n2, bl);
            int n3 = OS.gtk_container_get_border_width(this.handle);
            point.x += 2 * n3;
            point.y += 2 * n3;
            return point;
        }
        int n4 = 0;
        int n5 = 0;
        if ((n == -1 || n2 == -1) && this.itemCount > 0) {
            n4 += this.spacing;
            GC gC = new GC(this);
            int n6 = 0;
            while (n6 < this.itemCount) {
                ExpandItem expandItem = this.items[n6];
                n4 += expandItem.getHeaderHeight();
                if (expandItem.expanded) {
                    n4 += expandItem.height;
                }
                n4 += this.spacing;
                n5 = Math.max(n5, expandItem.getPreferredWidth(gC));
                ++n6;
            }
            gC.dispose();
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n5, n4);
    }

    void createHandle(int n) {
        this.state |= 8;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (this.fixedHandle == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_vbox_new(false, 0);
            if (this.handle == 0L) {
                this.error(2);
            }
            if ((this.style & 0x200) != 0) {
                this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
                if (this.scrolledHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
                long l = OS.gtk_bin_get_child(this.scrolledHandle);
                OS.gtk_viewport_set_shadow_type(l, 0);
            } else {
                OS.gtk_container_add(this.fixedHandle, this.handle);
            }
            OS.gtk_container_set_border_width(this.handle, 0);
        } else {
            long l = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
            if (l == 0L) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window(l, true);
            if ((this.style & 0x200) != 0) {
                this.fixedHandle = l;
                this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
                if (this.scrolledHandle == 0L) {
                    this.error(2);
                }
                this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_fixed_set_has_window(this.handle, true);
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                boolean bl = this.display.getWarnings();
                this.display.setWarnings(false);
                OS.gtk_container_add(this.scrolledHandle, this.handle);
                this.display.setWarnings(bl);
            } else {
                this.handle = l;
            }
            OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        }
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (n2 < 0 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus == null) {
            this.lastFocus = expandItem;
        }
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem expandItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && expandItem == this.lastFocus) {
            int n2;
            int n3 = n2 = n > 0 ? n - 1 : 1;
            if (n2 < this.itemCount) {
                this.lastFocus = this.items[n2];
                this.lastFocus.redraw();
            } else {
                this.lastFocus = null;
            }
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n, true);
    }

    long eventHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    boolean forceFocus(long l) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.lastFocus != null && this.lastFocus.setFocus()) {
                return true;
            }
            int n = 0;
            while (n < this.itemCount) {
                ExpandItem expandItem = this.items[n];
                if (expandItem.setFocus()) {
                    return true;
                }
                ++n;
            }
        }
        return super.forceFocus(l);
    }

    boolean hasFocus() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n = 0;
            while (n < this.itemCount) {
                ExpandItem expandItem = this.items[n];
                if (expandItem.hasFocus()) {
                    return true;
                }
                ++n;
            }
        }
        return super.hasFocus();
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && this.scrolledHandle != 0L) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.closures[47], true);
        }
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    GdkColor getForegroundColor() {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && (this.state & 0x1000) == 0) {
            return this.display.getSystemColor((int)30).handle;
        }
        return super.getForegroundColor();
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    long gtk_button_press_event(long l, long l2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
            int n = (int)gdkEventButton.x;
            int n2 = (int)gdkEventButton.y;
            int n3 = 0;
            while (n3 < this.itemCount) {
                boolean bl;
                ExpandItem expandItem = this.items[n3];
                boolean bl2 = bl = expandItem.x <= n && n < expandItem.x + expandItem.width && expandItem.y <= n2 && n2 < expandItem.y + this.getBandHeight();
                if (bl && expandItem != this.lastFocus) {
                    this.lastFocus.redraw();
                    this.lastFocus = expandItem;
                    this.lastFocus.redraw();
                    this.forceFocus();
                    break;
                }
                ++n3;
            }
        }
        return super.gtk_button_press_event(l, l2);
    }

    long gtk_button_release_event(long l, long l2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            boolean bl;
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
            int n = (int)gdkEventButton.x;
            int n2 = (int)gdkEventButton.y;
            boolean bl2 = bl = this.lastFocus.x <= n && n < this.lastFocus.x + this.lastFocus.width && this.lastFocus.y <= n2 && n2 < this.lastFocus.y + this.getBandHeight();
            if (bl) {
                Event event = new Event();
                event.item = this.lastFocus;
                this.notifyListeners(this.lastFocus.expanded ? 18 : 17, event);
                this.lastFocus.expanded = !this.lastFocus.expanded;
                this.showItem(this.lastFocus);
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    long gtk_expose_event(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
            GCData gCData = new GCData();
            gCData.damageRgn = gdkEventExpose.region;
            GC gC = GC.gtk_new(this, gCData);
            OS.gdk_gc_set_clip_region(gC.handle, gdkEventExpose.region);
            boolean bl = this.isFocusControl();
            int n = 0;
            while (n < this.itemCount) {
                ExpandItem expandItem = this.items[n];
                expandItem.drawItem(gC, bl && expandItem == this.lastFocus);
                ++n;
            }
            gC.dispose();
        }
        return super.gtk_expose_event(l, l2);
    }

    long gtk_focus_in_event(long l, long l2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_in_event(l, l2);
    }

    long gtk_focus_out_event(long l, long l2) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.lastFocus != null) {
            this.lastFocus.redraw();
        }
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_key_press_event(long l, long l2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (!this.hasFocus()) {
                return 0L;
            }
            long l3 = super.gtk_key_press_event(l, l2);
            if (l3 != 0L) {
                return l3;
            }
            int n = 0;
            while (n < this.itemCount) {
                if (this.items[n].hasFocus()) break;
                ++n;
            }
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            boolean bl = false;
            switch (gdkEventKey.keyval) {
                case 65361: 
                case 65362: {
                    bl = false;
                    break;
                }
                case 65363: 
                case 65364: {
                    bl = true;
                    break;
                }
                default: {
                    return l3;
                }
            }
            int n2 = n;
            int n3 = bl ? 1 : -1;
            while ((n = (n + n3 + this.itemCount) % this.itemCount) != n2) {
                ExpandItem expandItem = this.items[n];
                if (!expandItem.setFocus()) continue;
                return l3;
            }
            return l3;
        }
        if (this.lastFocus != null) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.keyval) {
                case 32: 
                case 65293: {
                    Event event = new Event();
                    event.item = this.lastFocus;
                    this.sendEvent(this.lastFocus.expanded ? 18 : 17, event);
                    this.lastFocus.expanded = !this.lastFocus.expanded;
                    this.showItem(this.lastFocus);
                    break;
                }
                case 65362: 
                case 65431: {
                    int n = this.indexOf(this.lastFocus);
                    if (n <= 0) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[n - 1];
                    this.lastFocus.redraw();
                    break;
                }
                case 65364: 
                case 65433: {
                    int n = this.indexOf(this.lastFocus);
                    if (n >= this.itemCount - 1) break;
                    this.lastFocus.redraw();
                    this.lastFocus = this.items[n + 1];
                    this.lastFocus.redraw();
                }
            }
        }
        return super.gtk_key_press_event(l, l2);
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == expandItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n2 = 0;
            while (n2 < this.itemCount) {
                ExpandItem expandItem = this.items[n2];
                if (expandItem != null) {
                    expandItem.resizeControl(this.yCurrentScroll);
                }
                ++n2;
            }
        } else {
            if (n < this.itemCount) {
                ExpandItem expandItem;
                int n3 = this.spacing - this.yCurrentScroll;
                int n4 = 0;
                while (n4 < n) {
                    expandItem = this.items[n4];
                    if (expandItem.expanded) {
                        n3 += expandItem.height;
                    }
                    n3 += expandItem.getHeaderHeight() + this.spacing;
                    ++n4;
                }
                n4 = n;
                while (n4 < this.itemCount) {
                    expandItem = this.items[n4];
                    expandItem.setBounds(this.spacing, n3, 0, 0, true, false);
                    if (expandItem.expanded) {
                        n3 += expandItem.height;
                    }
                    n3 += expandItem.getHeaderHeight() + this.spacing;
                    ++n4;
                }
            }
            if (bl) {
                this.setScrollbar();
            }
        }
    }

    long gtk_size_allocate(long l, long l2) {
        long l3 = super.gtk_size_allocate(l, l2);
        this.layoutItems(0, false);
        return l3;
    }

    long parentingHandle() {
        return OS.GTK_VERSION >= OS.VERSION(2, 4, 0) ? this.fixedHandle : this.handle;
    }

    void releaseChildren(boolean bl) {
        int n = 0;
        while (n < this.itemCount) {
            ExpandItem expandItem = this.items[n];
            if (expandItem != null && !expandItem.isDisposed()) {
                expandItem.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ExpandItem expandItem = this.items[n2];
                if (expandItem != null) {
                    expandItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && bl2) {
            if ((this.style & 0x200) != 0) {
                this.setScrollbar();
            } else {
                int n6 = 0;
                while (n6 < this.itemCount) {
                    ExpandItem expandItem = this.items[n6];
                    int n7 = Math.max(0, this.getClientArea().width - this.spacing * 2);
                    if (expandItem.width != n7) {
                        expandItem.setBounds(0, 0, n7, expandItem.height, false, true);
                    }
                    ++n6;
                }
            }
        }
        return n5;
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n = 0;
            while (n < this.itemCount) {
                this.items[n].setFontDescription(l);
                ++n;
            }
            this.layoutItems(0, true);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n = 0;
            while (n < this.itemCount) {
                this.items[n].setForegroundColor(gdkColor);
                ++n;
            }
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] != null) {
                    this.items[n].setOrientation(bl);
                }
                ++n;
            }
        }
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        int n = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n2 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n2 += expandItem.height;
        }
        long l = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        this.yCurrentScroll = (int)gtkAdjustment.value;
        if (this.yCurrentScroll > 0 && n > n2) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n2 - n);
            this.layoutItems(0, false);
        }
        gtkAdjustment.value = Math.min(this.yCurrentScroll, n2 += this.yCurrentScroll);
        gtkAdjustment.upper = n2;
        gtkAdjustment.page_size = n;
        OS.memmove(l, gtkAdjustment);
        OS.gtk_adjustment_changed(l);
        int n3 = n2 > n ? 0 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, n3);
        int n4 = OS.GTK_WIDGET_WIDTH(this.fixedHandle) - this.spacing * 2;
        if (n3 == 0) {
            long l2 = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_size_request(l2, gtkRequisition);
            n4 -= gtkRequisition.width;
        }
        n4 = Math.max(0, n4);
        int n5 = 0;
        while (n5 < this.itemCount) {
            ExpandItem expandItem2 = this.items[n5];
            expandItem2.setBounds(0, 0, n4, expandItem2.height, false, true);
            ++n5;
        }
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_box_set_spacing(this.handle, n);
            OS.gtk_container_set_border_width(this.handle, n);
        } else {
            if ((this.style & 0x200) == 0) {
                int n2 = Math.max(0, this.getClientArea().width - n * 2);
                int n3 = 0;
                while (n3 < this.itemCount) {
                    ExpandItem expandItem = this.items[n3];
                    if (expandItem.width != n2) {
                        expandItem.setBounds(0, 0, n2, expandItem.height, false, true);
                    }
                    ++n3;
                }
            }
            this.layoutItems(0, true);
            this.redraw();
        }
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        this.yCurrentScroll = scrollBar.getSelection();
        this.layoutItems(0, false);
    }
}

