/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;
import org.eclipse.swt.internal.cocoa.id;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new float[0];
        }
        float[] fArray = new float[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            fArray[n10] = n + n7 * n9;
            fArray[n10 + 1] = n4;
            fArray[n10 + 2] = fArray[n10] + (float)(n7 / 2);
            fArray[n10 + 3] = n2;
            ++n9;
        }
        fArray[n5 - 2] = n + n7 * n8;
        fArray[n5 - 1] = n4;
        return fArray;
    }

    void computeRuns() {
        Object object;
        Object object2;
        int n;
        if (this.lineBounds != null) {
            return;
        }
        String string = this.getSegmentsText();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithCharacters(cArray, cArray.length);
        NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
        nSString.release();
        nSMutableAttributedString.beginEditing();
        Font font = this.font != null ? this.font : this.device.systemFont;
        NSRange nSRange = new NSRange();
        nSRange.length = nSMutableAttributedString.length();
        nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
        nSMutableAttributedString.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), nSRange);
        font.addTraits(nSMutableAttributedString, nSRange);
        NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int n2 = 0;
        if (this.justify) {
            n2 = 3;
        } else {
            switch (this.alignment) {
                case 0x1000000: {
                    n2 = 2;
                    break;
                }
                case 131072: {
                    n2 = 1;
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            nSMutableParagraphStyle.setBaseWritingDirection(1L);
        } else {
            nSMutableParagraphStyle.setBaseWritingDirection(0L);
        }
        nSMutableParagraphStyle.setAlignment(n2);
        nSMutableParagraphStyle.setLineSpacing(this.spacing);
        nSMutableParagraphStyle.setFirstLineHeadIndent(this.indent);
        nSMutableParagraphStyle.setHeadIndent(this.wrapIndent);
        nSMutableParagraphStyle.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        nSMutableParagraphStyle.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            int n3 = this.tabs.length;
            if (n3 == 1) {
                nSMutableParagraphStyle.setDefaultTabInterval(this.tabs[0]);
            } else {
                n = 0;
                int n4 = 0;
                while (n4 < n3) {
                    n = this.tabs[n4];
                    NSTextTab nSTextTab = (NSTextTab)new NSTextTab().alloc();
                    nSTextTab = nSTextTab.initWithType(0L, n);
                    nSMutableParagraphStyle.addTabStop(nSTextTab);
                    nSTextTab.release();
                    ++n4;
                }
                int n5 = this.tabs[n3 - 1] - this.tabs[n3 - 2];
                while (n4 < 32) {
                    object2 = (NSTextTab)new NSTextTab().alloc();
                    object2 = ((NSTextTab)object2).initWithType(0L, n += n5);
                    nSMutableParagraphStyle.addTabStop((NSTextTab)object2);
                    ((NSObject)object2).release();
                    ++n4;
                }
            }
        }
        nSMutableAttributedString.addAttribute(OS.NSParagraphStyleAttributeName, nSMutableParagraphStyle, nSRange);
        nSMutableParagraphStyle.release();
        long l = nSMutableAttributedString.length();
        n = 0;
        while (n < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[n];
            if (styleItem.style != null) {
                Object object3;
                Object object4;
                Object object5;
                Color color;
                object2 = styleItem.style;
                nSRange.location = l != 0L ? this.translateOffset(styleItem.start) : 0;
                nSRange.length = (long)this.translateOffset(this.styles[n + 1].start) - nSRange.location;
                Font font2 = ((TextStyle)object2).font;
                if (font2 != null) {
                    nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font2.handle, nSRange);
                    font2.addTraits(nSMutableAttributedString, nSRange);
                }
                if ((color = ((TextStyle)object2).foreground) != null) {
                    object5 = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0);
                    nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object5, nSRange);
                }
                if ((object5 = ((TextStyle)object2).background) != null) {
                    object4 = NSColor.colorWithDeviceRed(((Color)object5).handle[0], ((Color)object5).handle[1], ((Color)object5).handle[2], 1.0);
                    nSMutableAttributedString.addAttribute(OS.NSBackgroundColorAttributeName, (id)object4, nSRange);
                }
                if (((TextStyle)object2).strikeout) {
                    nSMutableAttributedString.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), nSRange);
                    object4 = ((TextStyle)object2).strikeoutColor;
                    if (object4 != null) {
                        object3 = NSColor.colorWithDeviceRed(((Color)object4).handle[0], ((Color)object4).handle[1], ((Color)object4).handle[2], 1.0);
                        nSMutableAttributedString.addAttribute(OS.NSStrikethroughColorAttributeName, (id)object3, nSRange);
                    }
                }
                if (this.isUnderlineSupported((TextStyle)object2)) {
                    int n6 = 0;
                    switch (((TextStyle)object2).underlineStyle) {
                        case 0: {
                            n6 = 1;
                            break;
                        }
                        case 1: {
                            n6 = 9;
                            break;
                        }
                        case 65536: {
                            n6 = 2;
                            break;
                        }
                        case 4: {
                            n6 = 1;
                            if (color != null) break;
                            object3 = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0);
                            nSMutableAttributedString.addAttribute(OS.NSForegroundColorAttributeName, (id)object3, nSRange);
                        }
                    }
                    if (n6 != 0) {
                        nSMutableAttributedString.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(n6), nSRange);
                        object3 = ((TextStyle)object2).underlineColor;
                        if (object3 != null) {
                            object = NSColor.colorWithDeviceRed(((Color)object3).handle[0], ((Color)object3).handle[1], ((Color)object3).handle[2], 1.0);
                            nSMutableAttributedString.addAttribute(OS.NSUnderlineColorAttributeName, (id)object, nSRange);
                        }
                    }
                }
                if (((TextStyle)object2).rise != 0) {
                    nSMutableAttributedString.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(((TextStyle)object2).rise), nSRange);
                }
                if (((TextStyle)object2).metrics != null) {
                    this.initClasses();
                    char[] cArray2 = new char[(int)nSRange.length];
                    int n7 = 0;
                    while (n7 < cArray2.length) {
                        cArray2[n7] = 65532;
                        ++n7;
                    }
                    object3 = (NSString)new NSString().alloc();
                    object3 = ((NSString)object3).initWithCharacters(cArray2, cArray2.length);
                    nSMutableAttributedString.replaceCharactersInRange(nSRange, (NSString)object3);
                    ((NSObject)object3).release();
                    styleItem.jniRef = OS.NewGlobalRef(styleItem);
                    if (styleItem.jniRef == 0L) {
                        SWT.error(2);
                    }
                    styleItem.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
                    OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, styleItem.jniRef);
                    object = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
                    ((NSTextAttachment)object).setAttachmentCell(styleItem.cell);
                    nSMutableAttributedString.addAttribute(OS.NSAttachmentAttributeName, (id)object, nSRange);
                    ((NSObject)object).release();
                }
            }
            ++n;
        }
        nSMutableAttributedString.endEditing();
        NSSize nSSize = new NSSize();
        nSSize.width = this.wrapWidth != -1 ? (double)this.wrapWidth : 5000000.0;
        nSSize.height = 5000000.0;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(nSSize);
            this.textContainer.setLineFragmentPadding(0.0);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(nSSize);
        }
        this.textStorage.setAttributedString(nSMutableAttributedString);
        nSMutableAttributedString.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        long l2 = this.layoutManager.numberOfGlyphs();
        long l3 = OS.malloc(NSRange.sizeof);
        object = new NSRange();
        int n8 = 0;
        long l4 = 0L;
        while (l4 < l2) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l4, l3, true);
            OS.memmove((NSRange)object, l3, (long)NSRange.sizeof);
            l4 = ((NSRange)object).location + ((NSRange)object).length;
            ++n8;
        }
        if (n8 == 0) {
            ++n8;
        }
        int[] nArray = new int[n8 + 1];
        NSRect[] nSRectArray = new NSRect[n8];
        n8 = 0;
        l4 = 0L;
        while (l4 < l2) {
            nSRectArray[n8] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l4, l3, true);
            if (n8 < nSRectArray.length - 1) {
                nSRectArray[n8].height -= (double)this.spacing;
            }
            OS.memmove((NSRange)object, l3, (long)NSRange.sizeof);
            nArray[n8] = (int)((NSRange)object).location;
            l4 = ((NSRange)object).location + ((NSRange)object).length;
            ++n8;
        }
        if (n8 == 0) {
            Font font3 = this.font != null ? this.font : this.device.systemFont;
            NSFont nSFont = font3.handle;
            nSRectArray[0] = new NSRect();
            nSRectArray[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nSFont), (double)(this.ascent + this.descent));
        }
        OS.free(l3);
        nArray[n8] = (int)this.textStorage.length();
        this.lineOffsets = nArray;
        this.lineBounds = nSRectArray;
    }

    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        this.checkLayout();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = gC.checkGC(3073);
        try {
            int n6;
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            this.computeRuns();
            int n7 = this.translateOffset(this.text.length());
            if (n7 == 0 && n5 == 0) {
                Object var50_11 = null;
                gC.uncheckGC(nSAutoreleasePool);
                return;
            }
            gC.handle.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            NSRange nSRange = new NSRange();
            long l = this.layoutManager.numberOfGlyphs();
            if (l > 0L) {
                nSRange.location = 0L;
                nSRange.length = l;
                this.layoutManager.drawBackgroundForGlyphRange(nSRange, nSPoint);
            }
            boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
            if (bl || (n5 & 0x100000) != 0 && (n5 & 0x30000) != 0) {
                if (color2 == null) {
                    color2 = this.device.getSystemColor(26);
                }
                object3 = NSColor.colorWithDeviceRed(color2.handle[0], color2.handle[1], color2.handle[2], color2.handle[3]);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                object2 = new NSRect();
                if (bl) {
                    nSRange.location = this.translateOffset(n3);
                    nSRange.length = this.translateOffset(n4 - n3 + 1);
                    object = new long[1];
                    long l2 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, (long[])object);
                    n6 = 0;
                    while ((long)n6 < object[0]) {
                        OS.memmove((NSRect)object2, l2, (long)NSRect.sizeof);
                        this.fixRect((NSRect)object2);
                        ((NSRect)object2).x += nSPoint.x;
                        ((NSRect)object2).y += nSPoint.y;
                        ((NSRect)object2).height = Math.max(((NSRect)object2).height, (double)(this.ascent + this.descent));
                        nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                        ++n6;
                        l2 += (long)NSRect.sizeof;
                    }
                }
                if ((n5 & 0x30000) != 0 && (n5 & 0x100000) != 0) {
                    object = this.lineBounds[this.lineBounds.length - 1];
                    ((NSRect)object2).x = nSPoint.x + ((NSRect)object).x + ((NSRect)object).width;
                    ((NSRect)object2).y = (double)n2 + ((NSRect)object).y;
                    ((NSRect)object2).width = (n5 & 0x10000) != 0 ? 2.147483647E9 : ((NSRect)object).height / 3.0;
                    ((NSRect)object2).height = Math.max(((NSRect)object).height, (double)(this.ascent + this.descent));
                    nSBezierPath.appendBezierPathWithRect((NSRect)object2);
                }
                object3.setFill();
                nSBezierPath.fill();
            }
            if (l > 0L) {
                boolean bl3;
                nSRange.location = 0L;
                nSRange.length = l;
                object3 = gC.data.foreground;
                boolean bl4 = bl3 = object3[0] == 0.0 && object3[1] == 0.0 && object3[2] == 0.0 && object3[3] == 1.0 && gC.data.alpha == 255;
                if (!bl3) {
                    int n8 = 0;
                    while (n8 < this.stylesCount - 1) {
                        object = this.styles[n8];
                        if (!(((StyleItem)object).style != null && ((StyleItem)object).style.foreground != null || ((StyleItem)object).style != null && ((StyleItem)object).style.underline && ((StyleItem)object).style.underlineStyle == 4)) {
                            nSRange.location = n7 != 0 ? this.translateOffset(((StyleItem)object).start) : 0;
                            nSRange.length = (long)this.translateOffset(this.styles[n8 + 1].start) - nSRange.location;
                            this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gC.data.fg, nSRange);
                        }
                        ++n8;
                    }
                }
                nSRange.location = 0L;
                nSRange.length = l;
                this.layoutManager.drawGlyphsForGlyphRange(nSRange, nSPoint);
                if (!bl3) {
                    nSRange.location = 0L;
                    nSRange.length = n7;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, nSRange);
                }
                object2 = new NSPoint();
                int n9 = 0;
                while (n9 < this.stylesCount) {
                    StyleItem styleItem = this.styles[n9];
                    TextStyle textStyle = styleItem.style;
                    if (textStyle != null) {
                        n6 = textStyle.underline && !this.isUnderlineSupported(textStyle) ? 1 : 0;
                        n6 = n6 != 0 && (n9 + 1 == this.stylesCount || !textStyle.isAdherentUnderline(this.styles[n9 + 1].style)) ? 1 : 0;
                        boolean bl5 = textStyle.borderStyle != 0;
                        boolean bl6 = bl5 = bl5 && (n9 + 1 == this.stylesCount || !textStyle.isAdherentBorder(this.styles[n9 + 1].style));
                        if (n6 != 0 || bl5) {
                            int n10 = n9 + 1 < this.stylesCount ? this.translateOffset(this.styles[n9 + 1].start - 1) : n7;
                            int n11 = 0;
                            while (n11 < this.lineOffsets.length - 1) {
                                Object[] objectArray;
                                NSRect nSRect;
                                long l3;
                                int n12;
                                int n13 = this.untranslateOffset(this.lineOffsets[n11]);
                                int n14 = this.untranslateOffset(this.lineOffsets[n11 + 1] - 1);
                                if (n6 != 0) {
                                    n12 = styleItem.start;
                                    int n15 = n9;
                                    while (n15 > 0 && textStyle.isAdherentUnderline(this.styles[n15 - 1].style)) {
                                        n12 = this.styles[n15 - 1].start;
                                        --n15;
                                    }
                                    if ((n12 = this.translateOffset(n12)) <= n14 && n10 >= n13) {
                                        nSRange.location = Math.max(n13, n12);
                                        nSRange.length = (long)(Math.min(n14, n10) + 1) - nSRange.location;
                                        if (nSRange.length > 0L) {
                                            long[] lArray = new long[1];
                                            l3 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            double d = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, n13);
                                            objectArray = null;
                                            if (textStyle.underlineColor != null) {
                                                objectArray = textStyle.underlineColor.handle;
                                            }
                                            if (objectArray == null && textStyle.foreground != null) {
                                                objectArray = textStyle.foreground.handle;
                                            }
                                            if (objectArray != null) {
                                                NSColor.colorWithDeviceRed(objectArray[0], objectArray[1], objectArray[2], objectArray[3]).setStroke();
                                            }
                                            int n16 = 0;
                                            while ((long)n16 < lArray[0]) {
                                                OS.memmove(nSRect, l3, (long)NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                double d2 = nSPoint.x + nSRect.x;
                                                double d3 = nSPoint.y + nSRect.y + nSRect.height - d + 1.0;
                                                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                                                switch (textStyle.underlineStyle) {
                                                    case 2: {
                                                        nSBezierPath.setLineWidth(2.0);
                                                        nSBezierPath.setLineCapStyle(1L);
                                                        nSBezierPath.setLineJoinStyle(1L);
                                                        nSBezierPath.setLineDash(new double[]{1.0, 3.0}, 2L, 0.0);
                                                        ((NSPoint)object2).x = d2;
                                                        ((NSPoint)object2).y = d3 + 0.5;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        ((NSPoint)object2).x = d2 + nSRect.width;
                                                        ((NSPoint)object2).y = d3 + 0.5;
                                                        nSBezierPath.lineToPoint((NSPoint)object2);
                                                        break;
                                                    }
                                                    case 3: {
                                                        gC.handle.setShouldAntialias(false);
                                                        nSBezierPath.setLineWidth(1.0);
                                                        nSBezierPath.setLineCapStyle(0L);
                                                        nSBezierPath.setLineJoinStyle(0L);
                                                        double d4 = nSPoint.y + nSRect.y + nSRect.height;
                                                        float f = 1.0f;
                                                        float f2 = 2.0f * f;
                                                        double d5 = Math.min(d3 - (double)(f2 / 2.0f), d4 - (double)f2 - 1.0);
                                                        float[] fArray = this.computePolyline((int)d2, (int)d5, (int)(d2 + nSRect.width), (int)(d5 + (double)f2));
                                                        ((NSPoint)object2).x = fArray[0] + 0.5f;
                                                        ((NSPoint)object2).y = fArray[1] + 0.5f;
                                                        nSBezierPath.moveToPoint((NSPoint)object2);
                                                        int n17 = 2;
                                                        while (n17 < fArray.length) {
                                                            ((NSPoint)object2).x = fArray[n17] + 0.5f;
                                                            ((NSPoint)object2).y = fArray[n17 + 1] + 0.5f;
                                                            nSBezierPath.lineToPoint((NSPoint)object2);
                                                            n17 += 2;
                                                        }
                                                        break;
                                                    }
                                                }
                                                nSBezierPath.stroke();
                                                ++n16;
                                                l3 += (long)NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                if (bl5) {
                                    n12 = styleItem.start;
                                    int n18 = n9;
                                    while (n18 > 0 && textStyle.isAdherentBorder(this.styles[n18 - 1].style)) {
                                        n12 = this.styles[n18 - 1].start;
                                        --n18;
                                    }
                                    if ((n12 = this.translateOffset(n12)) <= n14 && n10 >= n13) {
                                        nSRange.location = Math.max(n13, n12);
                                        nSRange.length = (long)(Math.min(n14, n10) + 1) - nSRange.location;
                                        if (nSRange.length > 0L) {
                                            long[] lArray = new long[1];
                                            l3 = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                                            nSRect = new NSRect();
                                            gC.handle.saveGraphicsState();
                                            double[] dArray = null;
                                            if (textStyle.borderColor != null) {
                                                dArray = textStyle.borderColor.handle;
                                            }
                                            if (dArray == null && textStyle.foreground != null) {
                                                dArray = textStyle.foreground.handle;
                                            }
                                            if (dArray != null) {
                                                NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], dArray[3]).setStroke();
                                            }
                                            boolean bl7 = true;
                                            objectArray = null;
                                            switch (textStyle.borderStyle) {
                                                case 1: {
                                                    break;
                                                }
                                                case 2: {
                                                    objectArray = bl7 ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                                    break;
                                                }
                                                case 4: {
                                                    objectArray = bl7 ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                                    break;
                                                }
                                            }
                                            double[] dArray2 = null;
                                            if (objectArray != null) {
                                                dArray2 = new double[objectArray.length];
                                                int n19 = 0;
                                                while (n19 < dArray2.length) {
                                                    dArray2[n19] = !bl7 ? objectArray[n19] : objectArray[n19] * (float)bl7;
                                                    ++n19;
                                                }
                                            }
                                            int n20 = 0;
                                            while ((long)n20 < lArray[0]) {
                                                OS.memmove(nSRect, l3, (long)NSRect.sizeof);
                                                this.fixRect(nSRect);
                                                nSRect.x += nSPoint.x + 0.5;
                                                nSRect.y += nSPoint.y + 0.5;
                                                nSRect.width -= 0.5;
                                                nSRect.height -= 0.5;
                                                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                                                nSBezierPath.setLineDash(dArray2, dArray2 != null ? dArray2.length : 0, 0.0);
                                                nSBezierPath.appendBezierPathWithRect(nSRect);
                                                nSBezierPath.stroke();
                                                ++n20;
                                                l3 += (long)NSRect.sizeof;
                                            }
                                            gC.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                ++n11;
                            }
                        }
                    }
                    ++n9;
                }
            }
            gC.handle.restoreGraphicsState();
            Object var50_13 = null;
            gC.uncheckGC(nSAutoreleasePool);
            return;
        }
        catch (Throwable throwable) {
            Object var50_12 = null;
            gC.uncheckGC(nSAutoreleasePool);
            throw throwable;
        }
    }

    void fixRect(NSRect nSRect) {
        double d = -1.0;
        int n = 0;
        while (n < this.lineBounds.length) {
            NSRect nSRect2 = this.lineBounds[n];
            if (nSRect.y <= nSRect2.y && nSRect2.y <= nSRect.y + nSRect.height) {
                d = Math.max(d, nSRect2.x + nSRect2.width);
            }
            ++n;
        }
        if (d != -1.0 && nSRect.x + nSRect.width > d) {
            nSRect.width = d - nSRect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        int n = 0;
        while (n < this.stylesCount - 1) {
            StyleItem styleItem = this.styles[n];
            if (styleItem.cell != null) {
                OS.object_setInstanceVariable(styleItem.cell.id, SWT_OBJECT, 0L);
                styleItem.cell.release();
                styleItem.cell = null;
                OS.DeleteGlobalRef(styleItem.jniRef);
                styleItem.jniRef = 0L;
            }
            ++n;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        Rectangle rectangle;
        block5: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                NSRect nSRect = this.layoutManager.usedRectForTextContainer(this.textContainer);
                if (this.wrapWidth != -1) {
                    nSRect.width = this.wrapWidth;
                }
                if (this.text.length() == 0) {
                    Font font = this.font != null ? this.font : this.device.systemFont;
                    NSFont nSFont = font.handle;
                    nSRect.height = this.layoutManager.defaultLineHeightForFont(nSFont);
                }
                nSRect.height = Math.max(nSRect.height, (double)(this.ascent + this.descent)) + (double)this.spacing;
                rectangle = new Rectangle(0, 0, (int)Math.ceil(nSRect.width), (int)Math.ceil(nSRect.height));
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block6;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle;
        block10: {
            int n3;
            NSAutoreleasePool nSAutoreleasePool;
            block8: {
                Rectangle rectangle2;
                block9: {
                    block6: {
                        Rectangle rectangle3;
                        block7: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            this.computeRuns();
                            n3 = this.text.length();
                            if (n3 != 0) break block6;
                            rectangle3 = new Rectangle(0, 0, 0, 0);
                            Object var15_8 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        return rectangle3;
                    }
                    if (n <= n2) break block8;
                    rectangle2 = new Rectangle(0, 0, 0, 0);
                    Object var15_9 = null;
                    if (nSAutoreleasePool == null) break block9;
                    nSAutoreleasePool.release();
                }
                return rectangle2;
            }
            try {
                n = Math.min(Math.max(0, n), n3 - 1);
                n2 = Math.min(Math.max(0, n2), n3 - 1);
                n = this.translateOffset(n);
                n2 = this.translateOffset(n2);
                NSRange nSRange = new NSRange();
                nSRange.location = n;
                nSRange.length = n2 - n + 1;
                long[] lArray = new long[1];
                long l = this.layoutManager.rectArrayForCharacterRange(nSRange, nSRange, this.textContainer, lArray);
                NSRect nSRect = new NSRect();
                int n4 = Integer.MAX_VALUE;
                int n5 = 0;
                int n6 = Integer.MAX_VALUE;
                int n7 = 0;
                int n8 = 0;
                while ((long)n8 < lArray[0]) {
                    OS.memmove(nSRect, l, (long)NSRect.sizeof);
                    this.fixRect(nSRect);
                    n4 = Math.min(n4, (int)nSRect.x);
                    n5 = Math.max(n5, (int)Math.ceil(nSRect.x + nSRect.width));
                    n6 = Math.min(n6, (int)nSRect.y);
                    n7 = Math.max(n7, (int)Math.ceil(nSRect.y + nSRect.height));
                    ++n8;
                    l += (long)NSRect.sizeof;
                }
                rectangle = new Rectangle(n4, n6, n5 - n4, n7 - n6);
                Object var15_10 = null;
                if (nSAutoreleasePool == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var15_11 = null;
                    if (nSAutoreleasePool == null) break block11;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int n) {
        byte by;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n2 = this.text.length();
                if (n < 0 || n > n2) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                long l = this.layoutManager.glyphIndexForCharacterAtIndex(n);
                NSRange nSRange = new NSRange();
                nSRange.location = l;
                nSRange.length = 1L;
                byte[] byArray = new byte[1];
                this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
                by = byArray[0];
                Object var8_8 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var8_9 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return by;
    }

    public int[] getLineOffsets() {
        int[] nArray;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int[] nArray2 = new int[this.lineOffsets.length];
                int n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = this.untranslateOffset(this.lineOffsets[n]);
                    ++n;
                }
                nArray = nArray2;
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLineIndex(int n) {
        int n2;
        NSAutoreleasePool nSAutoreleasePool;
        block7: {
            int n3;
            this.checkLayout();
            nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                int n4 = this.text.length();
                if (n < 0 || n > n4) {
                    SWT.error(6);
                }
                n = this.translateOffset(n);
                int n5 = 0;
                while (true) {
                    if (n5 >= this.lineOffsets.length - 1) {
                        n2 = this.lineBounds.length - 1;
                        break block7;
                    }
                    if (this.lineOffsets[n5 + 1] > n) {
                        n3 = n5;
                        Object var5_7 = null;
                        if (nSAutoreleasePool == null) return n3;
                        break;
                    }
                    ++n5;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (nSAutoreleasePool == null) throw throwable;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return n3;
        }
        Object var5_8 = null;
        if (nSAutoreleasePool == null) return n2;
        nSAutoreleasePool.release();
        return n2;
    }

    public Rectangle getLineBounds(int n) {
        Rectangle rectangle;
        block4: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                if (n < 0 || n >= this.lineBounds.length) {
                    SWT.error(6);
                }
                NSRect nSRect = this.lineBounds[n];
                int n2 = Math.max((int)Math.ceil(nSRect.height), this.ascent + this.descent);
                rectangle = new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSRect.width), n2);
                Object var5_6 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_7 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public int getLineCount() {
        int n;
        block3: {
            this.checkLayout();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                this.computeRuns();
                n = this.lineOffsets.length - 1;
                Object var2_3 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var2_4 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    public FontMetrics getLineMetrics(int n) {
        FontMetrics fontMetrics;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                FontMetrics fontMetrics2;
                block6: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int n2;
                        this.computeRuns();
                        int n3 = this.getLineCount();
                        if (n < 0 || n >= n3) {
                            SWT.error(6);
                        }
                        if ((n2 = this.text.length()) != 0) break block5;
                        Font font = this.font != null ? this.font : this.device.systemFont;
                        int n4 = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                        int n5 = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - n4;
                        n4 = Math.max(n4, this.ascent);
                        n5 = Math.max(n5, this.descent);
                        fontMetrics2 = FontMetrics.cocoa_new(n4, n5, 0, 0, n4 + n5);
                        Object var8_12 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var8_14 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return fontMetrics2;
            }
            Rectangle rectangle = this.getLineBounds(n);
            int n6 = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[n]);
            fontMetrics = FontMetrics.cocoa_new(rectangle.height - n6, n6, 0, 0, rectangle.height);
            Object var8_13 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return fontMetrics;
    }

    public Point getLocation(int n, boolean bl) {
        Point point;
        block13: {
            NSAutoreleasePool nSAutoreleasePool;
            block11: {
                Point point2;
                block12: {
                    int n2;
                    block9: {
                        Point point3;
                        block10: {
                            this.checkLayout();
                            nSAutoreleasePool = null;
                            if (!NSThread.isMainThread()) {
                                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                            }
                            try {
                                this.computeRuns();
                                n2 = this.text.length();
                                if (n < 0 || n > n2) {
                                    SWT.error(6);
                                }
                                if (n2 != 0) break block9;
                                point3 = new Point(0, 0);
                                Object var18_8 = null;
                                if (nSAutoreleasePool == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var18_11 = null;
                                    if (nSAutoreleasePool == null) break block14;
                                    nSAutoreleasePool.release();
                                }
                                throw throwable;
                            }
                            nSAutoreleasePool.release();
                        }
                        return point3;
                    }
                    if (n != n2) break block11;
                    NSRect nSRect = this.lineBounds[this.lineBounds.length - 1];
                    point2 = new Point((int)(nSRect.x + nSRect.width), (int)nSRect.y);
                    Object var18_9 = null;
                    if (nSAutoreleasePool == null) break block12;
                    nSAutoreleasePool.release();
                }
                return point2;
            }
            n = this.translateOffset(n);
            long l = this.layoutManager.glyphIndexForCharacterAtIndex(n);
            NSRect nSRect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(l, 0L);
            NSPoint nSPoint = this.layoutManager.locationForGlyphAtIndex(l);
            boolean bl2 = false;
            NSRange nSRange = new NSRange();
            nSRange.location = l;
            nSRange.length = 1L;
            byte[] byArray = new byte[1];
            long l2 = this.layoutManager.getGlyphsInRange(nSRange, 0L, 0L, 0L, 0L, byArray);
            if (l2 > 0L) {
                boolean bl3 = bl2 = (byArray[0] & 1) != 0;
            }
            if (bl != bl2) {
                long[] lArray = new long[1];
                long l3 = this.layoutManager.rectArrayForGlyphRange(nSRange, nSRange, this.textContainer, lArray);
                if (lArray[0] > 0L) {
                    NSRect nSRect2 = new NSRect();
                    OS.memmove(nSRect2, l3, (long)NSRect.sizeof);
                    this.fixRect(nSRect2);
                    nSPoint.x += nSRect2.width;
                }
            }
            point = new Point((int)nSPoint.x, (int)nSRect.y);
            Object var18_10 = null;
            if (nSAutoreleasePool == null) break block13;
            nSAutoreleasePool.release();
        }
        return point;
    }

    public int getNextOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, true);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        switch (n2) {
            case 2: {
                char c;
                if ((n += n3) < 0 || n >= n4 || '\udc00' > (c = this.text.charAt(n)) || c > '\udfff' || n <= 0 || '\ud800' > (c = this.text.charAt(n - 1)) || c > '\udbff') return n;
                n += n3;
                return n;
            }
            case 4: {
                n = this.translateOffset(n);
                n = (int)this.textStorage.nextWordFromIndex(n, bl);
                return this.untranslateOffset(n);
            }
            case 8: {
                n = this.translateOffset(n);
                if (bl) {
                    n = (int)this.textStorage.nextWordFromIndex(n, true);
                    return this.untranslateOffset(n);
                } else {
                    n4 = this.translateOffset(n4);
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = (int)this.textStorage.nextWordFromIndex(n6, true);
                        if (n7 >= n) {
                            n = n6;
                            return this.untranslateOffset(n);
                        }
                        n6 = n7;
                    }
                }
                return this.untranslateOffset(n);
            }
            case 16: {
                n = this.translateOffset(n);
                if (bl) {
                    int n8 = this.translateOffset(n4);
                    while (n8 > 0) {
                        int n9 = (int)this.textStorage.nextWordFromIndex(n8, false);
                        if (n9 <= n) {
                            n = n8;
                            return this.untranslateOffset(n);
                        }
                        n8 = n9;
                    }
                    return this.untranslateOffset(n);
                }
                n = (int)this.textStorage.nextWordFromIndex(n, false);
                return this.untranslateOffset(n);
            }
        }
        return n;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        block9: {
            int n4;
            NSAutoreleasePool nSAutoreleasePool;
            block7: {
                block8: {
                    this.checkLayout();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        this.computeRuns();
                        if (nArray != null && nArray.length < 1) {
                            SWT.error(5);
                        }
                        if ((n4 = this.text.length()) != 0) break block7;
                        Object var12_6 = null;
                        if (nSAutoreleasePool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var12_8 = null;
                            if (nSAutoreleasePool == null) break block10;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return 0;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            double[] dArray = new double[1];
            long l = this.layoutManager.glyphIndexForPoint(nSPoint, this.textContainer, dArray);
            int n5 = (int)this.layoutManager.characterIndexForGlyphAtIndex(l);
            n5 = Math.min(this.untranslateOffset(n5), n4 - 1);
            if (nArray != null) {
                char c;
                nArray[0] = Math.round((float)dArray[0]);
                if (dArray[0] >= 0.5 && '\ud800' <= (c = this.text.charAt(n5)) && c <= '\udbff' && n5 + 1 < n4 && '\udc00' <= (c = this.text.charAt(n5 + 1)) && c <= '\udfff') {
                    nArray[0] = nArray[0] + 1;
                }
            }
            n3 = n5;
            Object var12_7 = null;
            if (nSAutoreleasePool == null) break block9;
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        int n3;
        block3: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                n3 = this._getOffset(n, n2, false);
                Object var4_5 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n3;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return this.text;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return this.text;
            }
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n4 < n2) {
            if (n5 < n3 && n4 == this.segments[n5]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
                cArray2[n4 + n5++] = n;
                continue;
            }
            cArray2[n4 + n5] = cArray[n4++];
        }
        while (n5 < n3) {
            this.segments[n5] = n4;
            n = this.segmentsChars != null && this.segmentsChars.length > n5 ? this.segmentsChars[n5] : n6;
            cArray2[n4 + n5++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.stylesCount) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String string = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(string) != 0L) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        long l = textLayoutCallback2.getAddress();
        if (l == 0L) {
            SWT.error(3);
        }
        long l2 = OS.CALLBACK_cellBaselineOffset(l);
        long l3 = OS.CALLBACK_NSTextAttachmentCell_cellSize(l);
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] byArray2 = byArray;
        int n = C.PTR_SIZEOF;
        int n2 = C.PTR_SIZEOF == 4 ? 2 : 3;
        long l4 = OS.objc_allocateClassPair(OS.class_NSCell, string, 0L);
        OS.class_addIvar(l4, SWT_OBJECT, n, (byte)n2, byArray2);
        OS.class_addProtocol(l4, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(l4, OS.sel_cellSize, l3, "@:");
        OS.class_addMethod(l4, OS.sel_cellBaselineOffset, l2, "@:");
        OS.objc_registerClassPair(l4);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle textStyle) {
        if (textStyle != null && textStyle.underline) {
            int n = textStyle.underlineStyle;
            return n == 0 || n == 1 || n == 4 || n == 65536;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void setAlignment(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setAscent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setDescent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setFont(Font var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 100->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setIndent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setWrapIndent(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setJustify(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setOrientation(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSegments(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSegmentsChars(char[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setSpacing(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 77->81)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setStyle(TextStyle var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 731->735)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setTabs(int[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setText(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 132->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void setWidth(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 82->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static long textLayoutProc(long l, long l2) {
        long[] lArray = new long[1];
        OS.object_getInstanceVariable(l, SWT_OBJECT, lArray);
        if (lArray[0] == 0L) {
            return 0L;
        }
        StyleItem styleItem = (StyleItem)OS.JNIGetObject(lArray[0]);
        if (styleItem == null) {
            return 0L;
        }
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return 0L;
        }
        GlyphMetrics glyphMetrics = textStyle.metrics;
        if (glyphMetrics == null) {
            return 0L;
        }
        if (l2 == OS.sel_cellSize) {
            NSSize nSSize = new NSSize();
            nSSize.width = glyphMetrics.width;
            nSSize.height = glyphMetrics.ascent + glyphMetrics.descent;
            long l3 = OS.malloc(NSSize.sizeof);
            OS.memmove(l3, nSSize, (long)NSSize.sizeof);
            return l3;
        }
        if (l2 == OS.sel_cellBaselineOffset) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.y = -glyphMetrics.descent;
            long l4 = OS.malloc(NSPoint.sizeof);
            OS.memmove(l4, nSPoint, (long)NSPoint.sizeof);
            return l4;
        }
        return 0L;
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        int n4 = 0;
        while (n4 < n3 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    static class StyleItem {
        TextStyle style;
        int start;
        long jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

