/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    NSOpenGLContext context;
    static NSMutableArray supportedPboardTypes = NSMutableArray.arrayWithCapacity(1L);

    static {
        supportedPboardTypes.retain();
        supportedPboardTypes.addObject(OS.NSStringPboardType);
    }

    Canvas() {
    }

    long attributedSubstringFromRange(long l, long l2, long l3) {
        if (this.ime != null) {
            return this.ime.attributedSubstringFromRange(l, l2, l3);
        }
        return super.attributedSubstringFromRange(l, l2, l3);
    }

    void sendFocusEvent(int n) {
        if (this.caret != null) {
            if (n == 15) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        super.sendFocusEvent(n);
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    long characterIndexForPoint(long l, long l2, long l3) {
        if (this.ime != null) {
            return this.ime.characterIndexForPoint(l, l2, l3);
        }
        return super.characterIndexForPoint(l, l2, l3);
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    void drawRect(long l, long l2, NSRect nSRect) {
        if (this.context != null && this.context.view() == null) {
            this.context.setView(this.view);
        }
        super.drawRect(l, l2, nSRect);
    }

    void drawWidget(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        super.drawWidget(l, nSGraphicsContext, nSRect);
        if (this.caret == null) {
            return;
        }
        if (this.caret.isShowing) {
            long l2 = nSGraphicsContext.graphicsPort();
            OS.CGContextSaveGState(l2);
            OS.CGContextSetBlendMode(l2, 10);
            Image image = this.caret.image;
            if (image != null) {
                NSImage nSImage = image.handle;
                NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
                if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return;
                }
                NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(nSImageRep);
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                NSSize nSSize = nSImage.size();
                cGRect.size.width = nSSize.width;
                cGRect.size.height = nSSize.height;
                long l3 = nSBitmapImageRep.bitmapData();
                long l4 = nSBitmapImageRep.bitmapFormat();
                long l5 = nSBitmapImageRep.bytesPerRow();
                int n = nSBitmapImageRep.hasAlpha() ? ((l4 & 1L) != 0L ? 4 : 3) : ((l4 & 1L) != 0L ? 6 : 5);
                long l6 = OS.CGDataProviderCreateWithData(0L, l3, l5 * (long)((int)nSSize.height), 0L);
                long l7 = OS.CGColorSpaceCreateDeviceRGB();
                long l8 = OS.CGImageCreate((int)nSSize.width, (int)nSSize.height, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.bitsPerPixel(), l5, l7, n, l6, 0L, true, 0);
                OS.CGColorSpaceRelease(l7);
                OS.CGDataProviderRelease(l6);
                OS.CGContextScaleCTM(l2, 1.0, -1.0);
                OS.CGContextTranslateCTM(l2, 0.0, -(nSSize.height + 2.0 * cGRect.origin.y));
                OS.CGContextSetBlendMode(l2, 10);
                OS.CGContextDrawImage(l2, cGRect, l8);
                OS.CGImageRelease(l8);
            } else {
                CGRect cGRect = new CGRect();
                cGRect.origin.x = this.caret.x;
                cGRect.origin.y = this.caret.y;
                cGRect.size.width = this.caret.width != 0 ? this.caret.width : 1;
                cGRect.size.height = this.caret.height;
                long l9 = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(l2, l9);
                OS.CGColorSpaceRelease(l9);
                OS.CGContextSetFillColor(l2, new double[]{1.0, 1.0, 1.0, 1.0});
                OS.CGContextFillRect(l2, cGRect);
            }
            OS.CGContextRestoreGState(l2);
        }
    }

    NSRect firstRectForCharacterRange(long l, long l2, long l3) {
        if (this.ime != null) {
            return this.ime.firstRectForCharacterRange(l, l2, l3);
        }
        return super.firstRectForCharacterRange(l, l2, l3);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    boolean hasMarkedText(long l, long l2) {
        if (this.ime != null) {
            return this.ime.hasMarkedText(l, l2);
        }
        return super.hasMarkedText(l, l2);
    }

    boolean imeInComposition() {
        return this.ime != null && this.ime.isInlineEnabled() && this.ime.startOffset != -1;
    }

    boolean insertText(long l, long l2, long l3) {
        if (this.ime != null && !this.ime.insertText(l, l2, l3)) {
            return false;
        }
        return super.insertText(l, l2, l3);
    }

    boolean isOpaque(long l, long l2) {
        if (this.context != null) {
            return true;
        }
        return super.isOpaque(l, l2);
    }

    NSRange markedRange(long l, long l2) {
        if (this.ime != null) {
            return this.ime.markedRange(l, l2);
        }
        return super.markedRange(l, l2);
    }

    boolean readSelectionFromPasteboard(long l, long l2, long l3) {
        boolean bl = false;
        NSPasteboard nSPasteboard = new NSPasteboard(l3);
        NSArray nSArray = nSPasteboard.types();
        long l4 = 0L;
        while (l4 < supportedPboardTypes.count()) {
            if (bl) break;
            NSString nSString = new NSString(supportedPboardTypes.objectAtIndex(l4));
            if (nSArray.containsObject(nSString)) {
                bl = this.readSelectionFromPasteboard(nSPasteboard, nSString);
            }
            ++l4;
        }
        return bl;
    }

    boolean readSelectionFromPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        Object object;
        boolean bl = false;
        Object object2 = null;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (object = nSPasteboard.stringForType(OS.NSStringPboardType)) != null && ((NSString)object).length() > 0L) {
            object2 = object;
        }
        if (object2 != null) {
            object = this.getAccessible();
            ((Accessible)object).internal_accessibilitySetValue_forAttribute((id)object2, OS.NSAccessibilitySelectedTextAttribute, -1);
            bl = true;
        }
        return bl;
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Control[] controlArray;
        Control control;
        boolean bl2;
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl3;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isDrawing()) {
            return;
        }
        NSRect nSRect = this.view.visibleRect();
        if (nSRect.width <= 0.0 || nSRect.height <= 0.0) {
            return;
        }
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        if ((rectangle2 = new Rectangle(n3, n4, n5, n6)).intersects(rectangle = this.getClientArea())) {
            this.getShell().setScrolling();
            this.update(bl);
        }
        boolean bl5 = bl2 = (control = this.findBackgroundControl()) != null && control.backgroundImage != null;
        if (!bl2) {
            bl2 = this.hasRegion();
        }
        if (!bl2) {
            bl2 = this.isObscured();
        }
        if (bl2) {
            this.redrawWidget(this.view, n3, n4, n5, n6, false);
            this.redrawWidget(this.view, n, n2, n5, n6, false);
        } else {
            boolean bl6;
            controlArray = new NSRect();
            controlArray.x = n3;
            controlArray.y = n4;
            controlArray.width = n5;
            controlArray.height = n6;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            this.view.lockFocus();
            OS.NSCopyBits(0L, (NSRect)controlArray, nSPoint);
            this.view.unlockFocus();
            boolean bl7 = bl6 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2;
            if (bl6) {
                this.view.setNeedsDisplayInRect((NSRect)controlArray);
            } else {
                int n9;
                if (n7 != 0) {
                    n9 = n - n7;
                    if (n7 < 0) {
                        n9 = n + n5;
                    }
                    controlArray.x = n9;
                    controlArray.width = Math.abs(n7);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (n8 != 0) {
                    n9 = n2 - n8;
                    if (n8 < 0) {
                        n9 = n2 + n6;
                    }
                    controlArray.x = n3;
                    controlArray.y = n9;
                    controlArray.width = n5;
                    controlArray.height = Math.abs(n8);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
            object = new NSRect();
            ((NSRect)object).x = rectangle2.x;
            ((NSRect)object).y = rectangle2.y;
            ((NSRect)object).width = rectangle2.width;
            ((NSRect)object).height = rectangle2.height;
            OS.NSIntersectionRect(nSRect, nSRect, (NSRect)object);
            if (!OS.NSEqualRects(nSRect, (NSRect)object)) {
                if (((NSRect)object).x != nSRect.x) {
                    controlArray.x = ((NSRect)object).x + (double)n7;
                    controlArray.y = ((NSRect)object).y + (double)n8;
                    controlArray.width = nSRect.x - ((NSRect)object).x;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.x + nSRect.width != ((NSRect)object).x + ((NSRect)object).width) {
                    controlArray.x = ((NSRect)object).x + nSRect.width + (double)n7;
                    controlArray.y = ((NSRect)object).y + (double)n8;
                    controlArray.width = ((NSRect)object).width - nSRect.width;
                    controlArray.height = ((NSRect)object).height;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y != ((NSRect)object).y) {
                    controlArray.x = nSRect.x + (double)n7;
                    controlArray.y = ((NSRect)object).y + (double)n8;
                    controlArray.width = nSRect.width;
                    controlArray.height = nSRect.y - ((NSRect)object).y;
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
                if (nSRect.y + nSRect.height != ((NSRect)object).y + ((NSRect)object).height) {
                    controlArray.x = nSRect.x + (double)n7;
                    controlArray.y = nSRect.y + nSRect.height + (double)n8;
                    controlArray.width = nSRect.width;
                    controlArray.height = ((NSRect)object).y + ((NSRect)object).height - (nSRect.y + nSRect.height);
                    this.view.setNeedsDisplayInRect((NSRect)controlArray);
                }
            }
        }
        if (bl) {
            controlArray = this._getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control2 = controlArray[n10];
                object = control2.getBounds();
                if (Math.min(n3 + n5, ((Rectangle)object).x + ((Rectangle)object).width) >= Math.max(n3, ((Rectangle)object).x) && Math.min(n4 + n6, ((Rectangle)object).y + ((Rectangle)object).height) >= Math.max(n4, ((Rectangle)object).y)) {
                    control2.setLocation(((Rectangle)object).x + n7, ((Rectangle)object).y + n8);
                }
                ++n10;
            }
        }
        if (bl3) {
            this.caret.setFocus();
        }
    }

    NSRange selectedRange(long l, long l2) {
        if (this.ime != null) {
            return this.ime.selectedRange(l, l2);
        }
        return super.selectedRange(l, l2);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        if (this.caret != null) {
            NSCursor.setHiddenUntilMouseMoves(true);
        }
        return super.sendKeyEvent(nSEvent, n);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void setOpenGLContext(Object object) {
        this.context = (NSOpenGLContext)object;
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    boolean setMarkedText_selectedRange(long l, long l2, long l3, long l4) {
        if (this.ime != null && !this.ime.setMarkedText_selectedRange(l, l2, l3, l4)) {
            return false;
        }
        return super.setMarkedText_selectedRange(l, l2, l3, l4);
    }

    long validAttributesForMarkedText(long l, long l2) {
        if (this.ime != null) {
            return this.ime.validAttributesForMarkedText(l, l2);
        }
        return super.validAttributesForMarkedText(l, l2);
    }

    long validRequestorForSendType(long l, long l2, long l3, long l4) {
        NSArray nSArray;
        Accessible accessible;
        if (l == this.view.id && (accessible = this.getAccessible()) != null && (nSArray = accessible.internal_accessibilityAttributeNames(-1)) != null) {
            NSString nSString;
            id id2;
            boolean bl;
            boolean bl2 = nSArray.containsObject(OS.NSAccessibilitySelectedTextAttribute);
            boolean bl3 = accessible.internal_accessibilityIsAttributeSettable(OS.NSAccessibilitySelectedTextAttribute, -1);
            boolean bl4 = bl = supportedPboardTypes.containsObject(new id(l3)) && supportedPboardTypes.containsObject(new id(l4));
            if (bl2 && bl3 && bl && (id2 = accessible.internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString = new NSString(id2)).length() > 0L) {
                return this.view.id;
            }
        }
        return super.validRequestorForSendType(l, l2, l3, l4);
    }

    void updateOpenGLContext(long l, long l2, long l3) {
        if (this.context != null) {
            this.context.update();
        }
    }

    boolean writeSelectionToPasteboard(long l, long l2, long l3, long l4) {
        NSString nSString;
        boolean bl = false;
        NSPasteboard nSPasteboard = new NSPasteboard(l3);
        NSArray nSArray = new NSArray(l4);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(2L);
        long l5 = 0L;
        while (l5 < supportedPboardTypes.count()) {
            nSString = new NSString(supportedPboardTypes.objectAtIndex(l5));
            if (nSArray.containsObject(nSString)) {
                nSMutableArray.addObject(nSString);
            }
            ++l5;
        }
        if (nSMutableArray.count() > 0L) {
            nSPasteboard.declareTypes(nSMutableArray, this.view);
            l5 = 0L;
            while (l5 < nSMutableArray.count()) {
                nSString = new NSString(nSMutableArray.objectAtIndex(l5));
                if (this.writeSelectionToPasteboard(nSPasteboard, nSString)) {
                    bl = true;
                }
                ++l5;
            }
        }
        return bl;
    }

    boolean writeSelectionToPasteboard(NSPasteboard nSPasteboard, NSString nSString) {
        NSString nSString2;
        Accessible accessible;
        id id2;
        boolean bl = false;
        if (nSString.isEqualToString(OS.NSStringPboardType) && (id2 = (accessible = this.getAccessible()).internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (nSString2 = new NSString(id2)).length() > 0L) {
            bl = nSPasteboard.setString(nSString2, OS.NSStringPboardType);
        }
        return bl;
    }
}

