/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Version;
import java.io.File;

public abstract class AbstractCPCFImport
extends AbstractImport {
    protected final Fragments fragments;
    protected final SourcePositions sourcePositions;
    protected final Files files;

    public AbstractCPCFImport(File rcfFile) {
        super(rcfFile);
        this.fragments = this.rcf.getFragments();
        this.sourcePositions = this.rcf.getSourcePositions();
        this.files = this.rcf.getFiles();
    }

    protected Fragment createFragment(String fileName, Version v, int beginLine, int endLine, int numTokens) {
        Fragment f = this.createFragment(fileName, v, beginLine, endLine);
        f.setNumTokens(numTokens);
        return f;
    }

    protected Fragment createFragment(String fileName, Version v, int beginLine, int endLine) {
        SourcePosition spStart = this.createSourcePosition(fileName, v, beginLine);
        SourcePosition spEnd = this.createSourcePosition(fileName, v, endLine);
        Fragment f = (Fragment)this.fragments.append();
        f.setStart(spStart);
        f.setEnd(spEnd);
        return f;
    }

    private SourcePosition createSourcePosition(String fileName, Version v, int line) {
        SourcePosition sp = (SourcePosition)this.sourcePositions.append();
        sp.setLine(line);
        sp.setFile(this.files.addFile(fileName, v));
        return sp;
    }
}

