/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractCPCFImport;
import de.uni_bremen.st.rcf.imports.ImportUtils;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class CCFImport
extends AbstractCPCFImport {
    private static final int CCF_FILE = 0;
    private static final int CCF_BEGIN_LINE = 1;
    private static final int CCF_BEGIN_COLUMN = 2;
    private static final int CCF_END_COLUMN = 4;

    public CCFImport(File rcfFile) {
        super(rcfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version addVersion(File ccfFile, String basepath) {
        CloneClasses ccRel = this.rcf.getCloneClasses();
        Version v = super.addVersion(ccfFile, basepath);
        BufferedReader bIn = null;
        try {
            bIn = new BufferedReader(new FileReader(ccfFile));
            String versionString = bIn.readLine();
            String[] vValues = versionString.split("-");
            boolean hasColumns = vValues[2].equalsIgnoreCase("LC");
            int CCF_END_LINE = hasColumns ? 3 : 2;
            String line = bIn.readLine();
            int lineNumber = 2;
            while (line != null) {
                String[] values = line.split("\t");
                if (values.length != 2) {
                    ImportUtils.reportError(ccfFile, lineNumber, line, null);
                }
                int cloneType = 0;
                ArrayList<Fragment> fragments = new ArrayList<Fragment>();
                try {
                    cloneType = Integer.parseInt(values[1]);
                    line = bIn.readLine();
                    ++lineNumber;
                    while (line != null && !line.startsWith("@")) {
                        String[] fValues = line.split("\t");
                        if (fValues.length != (hasColumns ? 5 : 3)) {
                            ImportUtils.reportError(ccfFile, lineNumber, line, null);
                        }
                        String fileName = fValues[0];
                        fileName = PathUtils.stripBasepath(basepath, fileName);
                        int beginLine = Integer.parseInt(fValues[1]);
                        int endLine = Integer.parseInt(fValues[CCF_END_LINE]);
                        int beginCol = hasColumns ? Integer.parseInt(fValues[2]) : -1;
                        int endCol = hasColumns ? Integer.parseInt(fValues[4]) : -1;
                        Fragment f = this.createFragment(fileName, v, beginLine, endLine);
                        if (beginCol > -1) {
                            f.getStart().setColumn(beginCol);
                        }
                        if (endCol > -1) {
                            f.getEnd().setColumn(endCol);
                        }
                        fragments.add(f);
                        line = bIn.readLine();
                        ++lineNumber;
                    }
                }
                catch (NumberFormatException nfe) {
                    ImportUtils.reportError(ccfFile, lineNumber, line, nfe);
                }
                ccRel.addCloneClass(v, 0, cloneType, fragments);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return v;
    }
}

