/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConqatImport
extends AbstractImport {
    private static final String ID = "id";
    private static final String PATH = "path";
    private static final String SRC_FILE_ID = "sourceFileId";
    private static final String LENGTH = "lengthInUnits";
    private static final String START_LINE = "startLine";
    private static final String LINE_COUNT = "lineCount";

    public ConqatImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File file, String basepath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            ConcatHandler handler = new ConcatHandler(basepath);
            parser.parse(file, (DefaultHandler)handler);
            return handler.version;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private class ConcatHandler
    extends DefaultHandler {
        private final Map<Integer, de.uni_bremen.st.rcf.model.File> sourceFiles = new HashMap<Integer, de.uni_bremen.st.rcf.model.File>();
        private final List<Fragment> fragments = new ArrayList<Fragment>();
        private final CloneClasses relCloneClasses;
        private final Fragments relFragments;
        private final Files relFiles;
        private final SourcePositions relSourcePositions;
        private int ccId = -1;
        private final Version version;

        public ConcatHandler(String basepath) {
            RCF rcf = ConqatImport.this.getRCF();
            this.version = rcf.getVersions().addVersion(0, basepath);
            this.relCloneClasses = rcf.getCloneClasses();
            this.relFragments = rcf.getFragments();
            this.relFiles = rcf.getFiles();
            this.relSourcePositions = rcf.getSourcePositions();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("cloneClass")) {
                this.relCloneClasses.addCloneClass(this.version, this.ccId, 1, this.fragments);
                this.fragments.clear();
                this.ccId = -1;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("sourceFile")) {
                String idStr = attributes.getValue(ConqatImport.ID);
                String path = attributes.getValue(ConqatImport.PATH);
                try {
                    int id = Integer.parseInt(idStr);
                    if (this.sourceFiles.containsKey(id)) {
                        throw new SAXException("Redefinition of source file id " + idStr);
                    }
                    de.uni_bremen.st.rcf.model.File f = this.relFiles.addFile(path, this.version);
                    f.setClientId(id);
                    this.sourceFiles.put(id, f);
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (qName.equals("cloneClass")) {
                String idStr = attributes.getValue(ConqatImport.ID);
                try {
                    if (this.ccId != -1) {
                        throw new SAXException("Invalid composition of cloneClass tags.");
                    }
                    this.ccId = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
            if (qName.equals("clone")) {
                String idStr = attributes.getValue(ConqatImport.SRC_FILE_ID);
                try {
                    int id = Integer.parseInt(idStr);
                    de.uni_bremen.st.rcf.model.File file = this.sourceFiles.get(id);
                    if (file == null) {
                        throw new SAXException("Undefined sourceFileId: " + idStr);
                    }
                    int numTokens = Integer.parseInt(attributes.getValue(ConqatImport.LENGTH));
                    int startLine = Integer.parseInt(attributes.getValue(ConqatImport.START_LINE));
                    int lineCount = Integer.parseInt(attributes.getValue(ConqatImport.LINE_COUNT));
                    Fragment frag = (Fragment)this.relFragments.append();
                    frag.setNumTokens(numTokens);
                    SourcePosition start = (SourcePosition)this.relSourcePositions.append();
                    start.setFile(file);
                    start.setLine(startLine);
                    frag.setStart(start);
                    SourcePosition end = (SourcePosition)this.relSourcePositions.append();
                    end.setFile(file);
                    end.setLine(startLine + lineCount);
                    frag.setEnd(end);
                    this.fragments.add(frag);
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
            }
        }
    }
}

