/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.imports.CCFImport;
import de.uni_bremen.st.rcf.imports.CCFXImport;
import de.uni_bremen.st.rcf.imports.CPDImport;
import de.uni_bremen.st.rcf.imports.CPFImport;
import de.uni_bremen.st.rcf.imports.ConqatImport;
import de.uni_bremen.st.rcf.imports.NiCadImport;
import de.uni_bremen.st.rcf.imports.SimScanImport;
import de.uni_bremen.st.rcf.imports.SimianImport;
import de.uni_bremen.st.rcf.model.RCF;
import java.io.File;

public class Import {
    private Import() {
    }

    public static RCF importData(CloneFormat from, String srcFilename, String rcfFilename, String basepath) {
        if (from == null || basepath == null) {
            throw new IllegalArgumentException();
        }
        File srcFile = new File(srcFilename);
        File rcfFile = new File(rcfFilename);
        AbstractImport importer = null;
        switch (from) {
            case CPF: {
                importer = new CPFImport(rcfFile);
                break;
            }
            case CCF: {
                importer = new CCFImport(rcfFile);
                break;
            }
            case SIMSCAN: {
                importer = new SimScanImport(rcfFile);
                break;
            }
            case SIMIAN: {
                importer = new SimianImport(rcfFile);
                break;
            }
            case CPD: {
                importer = new CPDImport(rcfFile);
                break;
            }
            case NICAD: {
                importer = new NiCadImport(rcfFile);
                break;
            }
            case CCFX: {
                importer = new CCFXImport(rcfFile);
                break;
            }
            case CONQAT: {
                importer = new ConqatImport(rcfFile);
                break;
            }
            case RCF: {
                throw new IllegalArgumentException("Can't convert from RCF to RCF");
            }
            default: {
                throw new IllegalArgumentException("Unknown format.");
            }
        }
        importer.addVersion(srcFile, basepath);
        RCF rcf = importer.getRCF();
        rcf.save();
        return rcf;
    }

    public static enum CloneFormat {
        RCF,
        CPF,
        CCF,
        SIMSCAN,
        SIMIAN,
        CPD,
        NICAD,
        CCFX,
        CONQAT;

    }
}

