/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NiCadImport
extends AbstractImport {
    private static final String CLONECLASS = "class";
    private static final String CLIENTID = "id";
    private static final String FRAGMENT = "source";
    private static final String FRAGMENTID = "pcid";
    private static final String FILE = "file";
    private static final String STARTLINE = "startline";
    private static final String ENDLINE = "endline";

    public NiCadImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File niCadFile, String basepath) {
        Version v = super.addVersion(niCadFile, basepath);
        try {
            String validateXML = this.validateFile(niCadFile);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            NiCadHandler handler = new NiCadHandler(v, basepath);
            saxParser.parse(new InputSource(new StringReader(validateXML)), (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("error while parsing nicad xmlfile");
        }
        return v;
    }

    private String validateFile(File niCadFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(niCadFile));
        String result = new String();
        String line = "";
        while ((line = reader.readLine()) != null) {
            result = result.concat(line);
        }
        reader.close();
        String regex = "<source([^>]*)>.*?</source>";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(result);
        result = matcher.replaceAll("<source$1></source>");
        return result;
    }

    private class NiCadHandler
    extends DefaultHandler {
        private final Version m_version;
        private final String m_basepath;
        private List<Fragment> m_fragments;
        private int m_id;

        private NiCadHandler(Version version, String basepath) {
            this.m_version = version;
            this.m_basepath = basepath;
        }

        @Override
        public void startElement(String s, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(NiCadImport.CLONECLASS)) {
                this.m_fragments = new LinkedList<Fragment>();
                this.m_id = Integer.parseInt(attributes.getValue(NiCadImport.CLIENTID));
            } else if (qName.equals(NiCadImport.FRAGMENT)) {
                String file = attributes.getValue(NiCadImport.FILE);
                file = PathUtils.stripBasepath(this.m_basepath, file);
                int startLine = Integer.parseInt(attributes.getValue(NiCadImport.STARTLINE));
                int endLine = Integer.parseInt(attributes.getValue(NiCadImport.ENDLINE));
                Fragment f = NiCadImport.this.rcf.getFragments().addFragment(file, this.m_version, startLine, endLine, 0, 0, 0);
                f.setClientId(Integer.parseInt(attributes.getValue(NiCadImport.FRAGMENTID)));
                this.m_fragments.add(f);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals(NiCadImport.CLONECLASS)) {
                NiCadImport.this.rcf.getCloneClasses().addCloneClass(this.m_version, this.m_id, 1, this.m_fragments);
            }
        }
    }
}

