/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimScanImport
extends AbstractImport {
    public SimScanImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File simScanFile, String basepath) {
        BufferedReader reader;
        Version v = super.addVersion(simScanFile, basepath);
        v.setClientId(1);
        try {
            reader = new BufferedReader(new FileReader(simScanFile));
        }
        catch (FileNotFoundException fne) {
            throw new RuntimeException(fne);
        }
        try {
            String line = reader.readLine();
            while (line != null) {
                String[] simFragments = line.split(", ");
                List<Fragment> fragments = this.createFragments(simFragments, v);
                this.rcf.getCloneClasses().addCloneClass(v, 0, 0, fragments);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return v;
    }

    private List<Fragment> createFragments(String[] simFragments, Version v) {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (int i = 0; i < simFragments.length; ++i) {
            String simFragment = simFragments[i];
            int sep1 = simFragment.indexOf(45);
            int sep2 = simFragment.indexOf(58);
            int sep3 = simFragment.lastIndexOf(45);
            try {
                int id = Integer.valueOf(simFragment.substring(0, sep1));
                String path = simFragment.substring(sep1 + 1, sep2);
                int startLine = Integer.valueOf(simFragment.substring(sep2 + 1, sep3));
                int endLine = Integer.valueOf(simFragment.substring(sep3 + 1, simFragment.length()));
                Fragment fragment = this.rcf.getFragments().addFragment(path, v, startLine, endLine, 0, 0, 0);
                fragment.setClientId(id);
                fragments.add(fragment);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
        }
        return fragments;
    }
}

