/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports;

import de.uni_bremen.st.rcf.imports.AbstractImport;
import de.uni_bremen.st.rcf.imports.ImportUtils;
import de.uni_bremen.st.rcf.model.CloneClasses;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class SimianImport
extends AbstractImport {
    private static final int SIM_BEGIN = 2;
    private static final int SIM_END = 4;

    public SimianImport(File rcfFile) {
        super(rcfFile);
    }

    @Override
    public Version addVersion(File simFile, String basepath) {
        CloneClasses ccRel = this.rcf.getCloneClasses();
        Fragments fragRel = this.rcf.getFragments();
        Version v = super.addVersion(simFile, basepath);
        try {
            BufferedReader bIn = new BufferedReader(new FileReader(simFile));
            String line = bIn.readLine();
            int lineNumber = 1;
            while (line != null) {
                if (!(line = line.trim()).startsWith("Found")) {
                    line = bIn.readLine();
                    ++lineNumber;
                    continue;
                }
                if (line.matches("Found [0-9]+ duplicate lines in [0-9]+ blocks in [0-9]+ files.*")) {
                    line = bIn.readLine();
                    ++lineNumber;
                    continue;
                }
                ArrayList<Fragment> fragments = new ArrayList<Fragment>();
                line = bIn.readLine();
                ++lineNumber;
                while (line != null && !line.startsWith("Found")) {
                    line = line.trim();
                    String[] values = line.split(" ");
                    int beginLine = 0;
                    int endLine = 0;
                    int idx = line.indexOf("in ");
                    if (idx < 0) {
                        ImportUtils.reportError(simFile, lineNumber, line, null);
                    }
                    String fileName = line.substring(idx += 3);
                    fileName = PathUtils.stripBasepath(basepath, fileName);
                    try {
                        beginLine = Integer.parseInt(values[2]);
                        endLine = Integer.parseInt(values[4]);
                    }
                    catch (NumberFormatException nfe) {
                        ImportUtils.reportError(simFile, lineNumber, line, nfe);
                    }
                    Fragment f = fragRel.addFragment(fileName, v, beginLine, endLine, 0, 0, 0);
                    f.unset("numTokens");
                    fragments.add(f);
                    line = bIn.readLine();
                    ++lineNumber;
                }
                ccRel.addCloneClass(v, 0, 1, fragments);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return v;
    }
}

