/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports.ccfx;

import de.uni_bremen.st.rcf.imports.ccfx.CloneClass;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePair;
import de.uni_bremen.st.rcf.imports.ccfx.ClonePart;
import de.uni_bremen.st.rcf.imports.ccfx.exception.ModelException;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXClonePair;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXClonePart;
import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXToken;
import de.uni_bremen.st.rcf.imports.ccfx.util.ScannedFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Model {
    private static final String FILE_SEPARATOR_STR = File.separator;
    private static final char FILE_SEPARATOR_CHAR = File.separatorChar;
    private static final String VERSION = "version";
    private static final String FORMAT = "format";
    private static final String OPTION = "option";
    private static final String PREPROCESS_SCRIPT = "preprocess_script";
    private static final String SOURCE_FILES = "source_files {";
    private static final String CLONE_PAIRS = "clone_pairs {";
    public static final String CCFX_PREPDIR_OPTION = "-n";
    public static final String PREPROCESSED_FILE_POSTFIX = "-preprocessed_file_postfix";
    public static final String CCFXPREPDIR = ".ccfxprepdir";
    private File scannedDir;
    private File baseDir;
    private File ccfxPrepDirPath;
    private String version;
    private String format;
    private String preprocessScript;
    private final Map<String, String> options = new HashMap<String, String>();
    private final List<ScannedFile> scannedFiles = new ArrayList<ScannedFile>();
    private final Map<Integer, List<CCFXClonePair>> ccfxClones = new LinkedHashMap<Integer, List<CCFXClonePair>>();

    public Model(File file, File baseDir) throws IOException {
        if (null == baseDir) {
            throw new IllegalArgumentException("unexpected null-value for parameter baseDir");
        }
        if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.canRead())) {
            throw new FileNotFoundException("parameter baseDir is not a valid path");
        }
        this.baseDir = baseDir;
        this.parse(file);
    }

    public List<ClonePair> getClonePairs() {
        ArrayList<ClonePair> clonePairs = new ArrayList<ClonePair>();
        for (Integer id : this.ccfxClones.keySet()) {
            clonePairs.addAll(this.getClonePairsById(id));
        }
        return clonePairs;
    }

    public List<CloneClass> getCloneClasses() {
        ArrayList<CloneClass> cloneClasses = new ArrayList<CloneClass>();
        for (int id : this.ccfxClones.keySet()) {
            CloneClass cloneClass = new CloneClass(id);
            cloneClass.getClonePairs().addAll(this.getClonePairsById(id));
            cloneClasses.add(cloneClass);
        }
        return cloneClasses;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFormat() {
        return this.format;
    }

    public String getPreprocessScript() {
        return this.preprocessScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File file) throws IOException {
        if (null == file) {
            throw new IllegalArgumentException("unexpected null-value for parameter file");
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new FileNotFoundException("parameter file is not a valid file");
        }
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            this.parseOptions(bufferedReader);
            this.parseScannedFiles(bufferedReader);
            this.skipTo(CLONE_PAIRS, bufferedReader);
            this.parseClonePairs(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
    }

    private void parseOptions(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        while (null != line && !line.equals(SOURCE_FILES)) {
            Scanner scanner = new Scanner(line);
            scanner.useDelimiter(":");
            String option = scanner.next();
            scanner.skip(": ");
            if (option.equals(VERSION)) {
                this.version = scanner.nextLine();
            } else if (option.equals(FORMAT)) {
                this.format = scanner.nextLine();
            } else if (option.equals(PREPROCESS_SCRIPT)) {
                this.preprocessScript = scanner.nextLine();
            } else if (option.equals(OPTION)) {
                this.parseOption(scanner.nextLine());
            }
            line = bufferedReader.readLine();
        }
        if (null == this.scannedDir) {
            throw new ModelException("unexpected null-value for scanned directory (-n option in ccfx)");
        }
        this.checkEOF(line);
    }

    private void parseOption(String line) throws FileNotFoundException {
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter(" ");
        String option = scanner.next();
        String value = scanner.next();
        if (option.equals(CCFX_PREPDIR_OPTION)) {
            this.scannedDir = new File(this.correctPath(value));
            this.ccfxPrepDirPath = new File(this.stripPath(value.concat(FILE_SEPARATOR_STR).concat(CCFXPREPDIR)));
            if (!(this.ccfxPrepDirPath.exists() && this.ccfxPrepDirPath.isDirectory() && this.ccfxPrepDirPath.canRead())) {
                throw new FileNotFoundException("the ccfxprepdir-path ".concat(this.ccfxPrepDirPath.getPath().concat(" is not a valid path")));
            }
        }
        this.options.put(option, value);
    }

    private void parseScannedFiles(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        while (null != line && !line.equals("}")) {
            if (null == this.ccfxPrepDirPath) {
                throw new ModelException("unexpected null-value for ccfxprepdir");
            }
            Scanner scanner = new Scanner(line);
            int id = scanner.nextInt();
            scanner.skip("\t");
            String scannedFile = scanner.next();
            scannedFile = this.stripPath(scannedFile);
            String ccfxPrepFile = this.getCCFXPrepFile(scannedFile);
            this.scannedFiles.add(new ScannedFile(id, new File(scannedFile), new File(ccfxPrepFile)));
            line = bufferedReader.readLine();
        }
        this.checkEOF(line);
    }

    private void parseClonePairs(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        while (null != line && !line.equals("}")) {
            Scanner scanner = new Scanner(line);
            int id = scanner.nextInt();
            scanner.skip("\t");
            scanner.useDelimiter("\t");
            CCFXClonePart left = this.scanCCFXClonePart(scanner.next());
            CCFXClonePart right = this.scanCCFXClonePart(scanner.next());
            CCFXClonePair ccfxClonePair = new CCFXClonePair(id, left, right);
            List<CCFXClonePair> ccfxClonePairs = this.ccfxClones.get(id);
            if (null == ccfxClonePairs) {
                ccfxClonePairs = new ArrayList<CCFXClonePair>();
                this.ccfxClones.put(id, ccfxClonePairs);
            }
            ccfxClonePairs.add(ccfxClonePair);
            line = bufferedReader.readLine();
        }
        this.checkEOF(line);
    }

    private void skipTo(String skipTo, BufferedReader bufferedReader) throws IOException {
        String line;
        while (!(line = bufferedReader.readLine()).equals(skipTo)) {
        }
    }

    private String stripPath(String path) {
        String strippedPath = this.correctPath(path);
        strippedPath = strippedPath.replaceAll(this.scannedDir.getPath(), this.baseDir.getPath());
        return strippedPath;
    }

    private String correctPath(String path) {
        String correctedPath = path.replaceAll("/", FILE_SEPARATOR_STR);
        char lastChar = (correctedPath = correctedPath.replaceAll("\\\\", FILE_SEPARATOR_STR)).charAt(correctedPath.length() - 1);
        if (lastChar == FILE_SEPARATOR_CHAR) {
            correctedPath = correctedPath.substring(0, correctedPath.length() - 1);
        }
        return correctedPath;
    }

    private void checkEOF(String s) {
        if (null == s) {
            throw new ModelException("unexpected end of file");
        }
    }

    private CCFXClonePart scanCCFXClonePart(String clonePartInformation) {
        Scanner scanner = new Scanner(clonePartInformation);
        scanner.useDelimiter("\\.");
        int fileId = Integer.parseInt(scanner.next());
        scanner.skip("\\.");
        scanner.useDelimiter("-");
        int beginToken = Integer.parseInt(scanner.next());
        scanner.skip("-");
        int endToken = Integer.parseInt(scanner.nextLine());
        ScannedFile scannedFile = this.scannedFiles.get(fileId - 1);
        if (scannedFile.getCcfxTokens().size() == endToken + 1) {
            --endToken;
        }
        return new CCFXClonePart(fileId, scannedFile.getCcfxTokens().get(beginToken), scannedFile.getCcfxTokens().get(endToken - 1), endToken - beginToken);
    }

    private Set<ClonePair> getClonePairsById(int id) {
        LinkedHashSet<ClonePair> clonePairs = new LinkedHashSet<ClonePair>();
        for (CCFXClonePair ccfxClonePair : this.ccfxClones.get(id)) {
            clonePairs.add(this.toClonePair(ccfxClonePair));
        }
        return clonePairs;
    }

    private String getCCFXPrepFile(String scannedFile) {
        String preprocessedFilePostFix = this.options.get(PREPROCESSED_FILE_POSTFIX);
        if (null == preprocessedFilePostFix) {
            throw new ModelException("unexpected null-value for preprocessed_file_postfix");
        }
        return this.ccfxPrepDirPath.getPath().concat(FILE_SEPARATOR_STR).concat(scannedFile.substring(this.ccfxPrepDirPath.getPath().length() - CCFXPREPDIR.length())).concat(preprocessedFilePostFix);
    }

    private ClonePair toClonePair(CCFXClonePair ccfxClonePair) {
        CCFXClonePart left = ccfxClonePair.getLeft();
        CCFXClonePart right = ccfxClonePair.getRight();
        return new ClonePair(ccfxClonePair.getId(), this.toClonePart(left), this.toClonePart(right));
    }

    private ClonePart toClonePart(CCFXClonePart ccfxClonePart) {
        int fileId = ccfxClonePart.getFileId();
        ScannedFile scannedFile = this.scannedFiles.get(fileId - 1);
        CCFXToken ccfxTokenBegin = ccfxClonePart.getBeginToken();
        int beginLine = ccfxTokenBegin.getLineInt();
        int beginColumn = ccfxTokenBegin.getColumnInt();
        int beginOffset = ccfxTokenBegin.getOffsetInt();
        CCFXToken ccfxTokenEnd = ccfxClonePart.getEndToken();
        int endLine = ccfxTokenEnd.getLineInt();
        int endColumn = ccfxTokenEnd.getColumnInt();
        int endOffset = ccfxTokenEnd.getOffsetInt();
        return new ClonePart(scannedFile.getFile(), scannedFile.getCcfxTokens().size(), beginLine, beginColumn, beginOffset, endLine, endColumn, endOffset, ccfxClonePart.getNumTokens());
    }
}

