/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.imports.ccfx.util;

import de.uni_bremen.st.rcf.imports.ccfx.util.CCFXToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScannedFile {
    private int id;
    private String file;
    private final List<CCFXToken> ccfxTokens = new ArrayList<CCFXToken>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannedFile(int id, File scannedFile, File ccfxPrepFile) throws IOException {
        if (null == scannedFile) {
            throw new IllegalArgumentException("unexpected null-value for parameter scannedFile");
        }
        if (null == ccfxPrepFile) {
            throw new IllegalArgumentException("unexpected null-value for parameter ccfxPrepFile");
        }
        if (!(scannedFile.exists() && scannedFile.isFile() && scannedFile.canRead())) {
            throw new FileNotFoundException(scannedFile.getPath().concat(" is not a valid file"));
        }
        if (!(ccfxPrepFile.exists() && ccfxPrepFile.isFile() && ccfxPrepFile.canRead())) {
            throw new FileNotFoundException(ccfxPrepFile.getPath().concat(" is not a valid file"));
        }
        this.id = id;
        this.file = scannedFile.getPath();
        FileReader fileReader = new FileReader(ccfxPrepFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line;
            while (null != (line = bufferedReader.readLine())) {
                this.ccfxTokens.add(new CCFXToken(line));
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getFile() {
        return this.file;
    }

    public List<CCFXToken> getCcfxTokens() {
        return this.ccfxTokens;
    }
}

