/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.ValueList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ValueListIterator<T>
implements ListIterator<T> {
    private ValueList<T> valueList;
    private int last = -1;
    private int current;

    protected ValueListIterator(ValueList<T> valueList, int start) {
        this.valueList = valueList;
        this.current = start;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.valueList.size();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T t = this.valueList.get(this.current);
            this.last = this.current++;
            return t;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        this.valueList.remove(this.last);
        if (this.current > this.last) {
            --this.current;
        }
        this.last = -1;
    }

    @Override
    public void add(T e) {
        ++this.current;
        this.last = -1;
        this.valueList.add(this.current, e);
    }

    @Override
    public boolean hasPrevious() {
        return this.current > 0;
    }

    @Override
    public int nextIndex() {
        if (this.hasNext()) {
            return this.current;
        }
        return this.valueList.size();
    }

    @Override
    public T previous() {
        if (this.hasPrevious()) {
            --this.current;
            this.last = this.current;
            return this.valueList.get(this.current);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        if (this.hasPrevious()) {
            return this.current - 1;
        }
        return -1;
    }

    @Override
    public void set(T e) {
        if (this.last == -1) {
            throw new IllegalStateException();
        }
        this.valueList.set(this.last, e);
    }
}

