/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.ValueListInterface;
import java.util.AbstractList;

public class ValueSubList<T>
extends AbstractList<T> {
    private final ValueListInterface<T> list;
    private final int from;
    private int to;

    ValueSubList(ValueListInterface<T> list, int from, int to) {
        this.list = list;
        this.from = from;
        this.to = to;
        if (list == null) {
            throw new NullPointerException();
        }
        if (from < 0 || to > list.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IllegalArgumentException();
        }
    }

    private int rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int i = this.from + index;
        if (i < this.from || i >= this.to) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    @Override
    public void add(int index, T element) {
        int i = this.from + index;
        if (index < 0 || i > this.to) {
            throw new IndexOutOfBoundsException();
        }
        this.list.add(i, element);
        ++this.to;
    }

    @Override
    public T get(int index) {
        return this.list.get(this.rangeCheck(index));
    }

    @Override
    public T remove(int index) {
        T t = this.list.remove(this.rangeCheck(index));
        --this.to;
        return t;
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(this.rangeCheck(index), element);
    }

    @Override
    public int size() {
        return this.to - this.from;
    }
}

