/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.FormatInfo;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.IReader;
import de.uni_bremen.st.rcf.persistence.bauhaus.RCFBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationBinding;
import de.uni_bremen.st.rcf.schema.AttributePOJO;
import de.uni_bremen.st.rcf.schema.ParseException;
import de.uni_bremen.st.rcf.schema.Parser;
import de.uni_bremen.st.rcf.schema.RelationPOJO;
import de.uni_bremen.st.reuse.BauhausStreamReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class Reader21
implements IReader {
    private final BauhausStreamReader in = new BauhausStreamReader();
    private final File file;
    private final RCFBinding rcf;

    Reader21(File f) {
        this.file = f;
        this.rcf = new RCFBinding(f);
    }

    @Override
    public void read() {
        try {
            this.in.open(this.file.getAbsolutePath());
            this.readVersionInfo();
            this.readSchema();
            while (!this.in.isEOF()) {
                this.readAttributeData();
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.refreshRelations();
    }

    private void readVersionInfo() throws IOException {
        this.in.readString();
    }

    private void readSchema() throws IOException, ParseException {
        String schema = this.in.readString();
        Collection<RelationPOJO> relations = Parser.parse(schema);
        for (RelationPOJO rp : relations) {
            this.rcf.addRelation(rp.getName());
        }
        for (RelationPOJO rp : relations) {
            RelationBinding rel = (RelationBinding)this.rcf.getRelation(rp.getName());
            for (AttributePOJO ap : rp.getAttributes()) {
                if (ap.getName().equals("id")) continue;
                RelationPOJO refRelP = ap.getReferencedRelation();
                String refRelName = refRelP == null ? null : refRelP.getName();
                RelationBinding refRel = refRelName == null ? null : (RelationBinding)this.rcf.getRelation(refRelName);
                String[] enumValues = ap.getEnumValues() == null ? new String[]{} : ap.getEnumValues().toArray(new String[ap.getEnumValues().size()]);
                rel.addAttribute(ap.getName(), ap.getType(), ap.isList(), ap.isEnum(), refRel, enumValues);
            }
        }
    }

    private void readAttributeData() throws IOException {
        int i;
        String canonialName = this.in.readString();
        String[] parts = canonialName.split("\\.");
        assert (parts.length == 2);
        String relName = parts[0];
        String attName = parts[1];
        RelationBinding rel = (RelationBinding)this.rcf.getRelation(relName);
        AttributeBinding att = (AttributeBinding)rel.getAttribute(attName);
        int numValues = this.in.readInteger();
        switch (att.getType()) {
            case INTEGER: 
            case REFERENCE: {
                att.intData.ensureCapacity(numValues);
                for (i = 0; i < numValues; ++i) {
                    att.intData.add(this.in.readInteger());
                }
                break;
            }
            case FLOAT: {
                att.floatData.ensureCapacity(numValues);
                for (i = 0; i < numValues; ++i) {
                    att.floatData.add(this.in.readFloat());
                }
                break;
            }
            case STRING: {
                att.stringData.ensureCapacity(numValues);
                for (i = 0; i < numValues; ++i) {
                    att.stringData.add(this.in.readString());
                }
                break;
            }
            case BOOLEAN: {
                att.boolData.ensureCapacity(numValues);
                for (i = 0; i < numValues; ++i) {
                    att.boolData.add(this.in.readInteger8());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown attribute type");
            }
        }
        if (att.isList()) {
            numValues = this.in.readInteger();
            att.listStarts.ensureCapacity(numValues);
            for (i = 0; i < numValues; ++i) {
                att.listStarts.add(this.in.readInteger());
            }
            numValues = this.in.readInteger();
            att.listEnds.ensureCapacity(numValues);
            for (i = 0; i < numValues; ++i) {
                att.listEnds.add(this.in.readInteger());
            }
            numValues = this.in.readInteger();
            att.nextIndex.ensureCapacity(numValues);
            for (i = 0; i < numValues; ++i) {
                att.nextIndex.add(this.in.readInteger());
            }
        }
    }

    @Override
    public boolean isCompatible(FormatInfo fi) {
        return false;
    }

    @Override
    public RCFBinding getRCFBinding() {
        return this.rcf;
    }

    private void refreshRelations() {
        for (AbstractRelationBinding arb : this.rcf.getRelations()) {
            RelationBinding rb = (RelationBinding)arb;
            rb.refresh();
        }
    }
}

