/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.EntryBinding;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ValueListBinding<T>
extends AbstractValueListBinding<T> {
    private final int entryOffset;
    private final AttributeBinding ab;

    protected ValueListBinding(AbstractAttributeBinding attribute, AbstractEntryBinding entry) {
        super(attribute, entry);
        this.entryOffset = ((EntryBinding)entry).offset;
        this.ab = (AttributeBinding)attribute;
    }

    @Override
    public boolean add(T e) {
        int newLastIndex = 0;
        switch (this.attribute.getType()) {
            case INTEGER: {
                this.ab.intData.add((Integer)e);
                newLastIndex = this.ab.intData.size() - 1;
                break;
            }
            case FLOAT: {
                this.ab.floatData.add(((Float)e).floatValue());
                newLastIndex = this.ab.floatData.size() - 1;
                break;
            }
            case STRING: {
                this.ab.stringData.add((String)e);
                newLastIndex = this.ab.stringData.size() - 1;
                break;
            }
            case BOOLEAN: {
                boolean b = (Boolean)e;
                this.ab.boolData.add(b ? (byte)1 : 0);
                newLastIndex = this.ab.boolData.size() - 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int oldEndIndex = this.ab.listEnds.get(this.entryOffset);
        this.ab.listEnds.set(this.entryOffset, newLastIndex);
        if (this.ab.listStarts.get(this.entryOffset) == -1) {
            this.ab.listStarts.set(this.entryOffset, newLastIndex);
        }
        if (oldEndIndex != -1) {
            this.ab.nextIndex.set(oldEndIndex, newLastIndex);
        }
        this.ab.nextIndex.add(-1);
        return true;
    }

    @Override
    public boolean addReference(AbstractEntryBinding binding) {
        int newLastIndex = 0;
        this.ab.intData.add(binding.getId());
        newLastIndex = this.ab.intData.size() - 1;
        int oldEndIndex = this.ab.listEnds.get(this.entryOffset);
        this.ab.listEnds.set(this.entryOffset, newLastIndex);
        if (this.ab.listStarts.get(this.entryOffset) == -1) {
            this.ab.listStarts.set(this.entryOffset, newLastIndex);
        }
        if (oldEndIndex != -1) {
            this.ab.nextIndex.set(oldEndIndex, newLastIndex);
        }
        this.ab.nextIndex.add(-1);
        return true;
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addReference(int index, AbstractEntryBinding binding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        AttributeBinding ab = (AttributeBinding)this.attribute;
        ab.listStarts.set(this.entryOffset, -1);
        ab.listEnds.set(this.entryOffset, -1);
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this) {
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsReference(AbstractEntryBinding entryBinding) {
        Integer id = entryBinding.getId();
        for (T t : this) {
            if (!id.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        Iterator<T> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            T v = it.next();
            if (i == index) {
                return v;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public EntryBinding getReference(int index) {
        GenericIterator it = new GenericIterator();
        int i = 0;
        while (it.hasNext()) {
            int v = (Integer)it.next();
            if (i == index) {
                return new EntryBinding(this.attribute.getReferencedRelation(), v);
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(Object o) {
        Iterator<T> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            T v = it.next();
            if (v.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int indexOfReference(AbstractEntryBinding entryBinding) {
        Integer id = entryBinding.getId();
        int i = 0;
        for (T t : this) {
            if (id.equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.ab.listStarts.get(this.entryOffset) == -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new ValueListBindingIterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        T t = this.get(index);
        Iterator<T> it = this.iterator();
        for (int i = 0; i <= index; ++i) {
            it.next();
        }
        it.remove();
        return t;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        T t = this.get(index);
        GenericIterator it = (GenericIterator)this.iterator();
        for (int i = 0; i <= index; ++i) {
            it.next();
        }
        switch (this.attribute.getType()) {
            case INTEGER: {
                this.ab.intData.set(it.currentIdx, (Integer)value);
                break;
            }
            case FLOAT: {
                this.ab.floatData.set(it.currentIdx, ((Float)value).floatValue());
                break;
            }
            case STRING: {
                this.ab.stringData.set(it.currentIdx, (String)value);
                break;
            }
            case BOOLEAN: {
                boolean b = (Boolean)value;
                this.ab.boolData.set(it.currentIdx, b ? (byte)1 : 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return t;
    }

    @Override
    public AbstractEntryBinding setReference(int index, AbstractEntryBinding entry) {
        AttributeBinding ab = (AttributeBinding)this.attribute;
        GenericIterator it = (GenericIterator)this.iterator();
        for (int i = 0; i <= index; ++i) {
            it.next();
        }
        ab.intData.set(it.currentIdx, entry.getId());
        return null;
    }

    @Override
    public int size() {
        int i = 0;
        ValueListBindingIterator iterator = (ValueListBindingIterator)this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractEntryBinding> subListReference(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        Iterator<T> it = this.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = it.next();
        }
        return ret;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        Iterator<T> it = this.iterator();
        if (this.size() > a.length) {
            a = Arrays.copyOf(a, this.size());
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = it.hasNext() ? it.next() : null;
        }
        return a;
    }

    @Override
    public boolean addAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllReference(int index, List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOfReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractEntryBinding removeReferece(int index) {
        Iterator<AbstractEntryBinding> it = this.iteratorReference();
        EntryBinding t = this.getReference(index);
        for (int i = 0; i <= index; ++i) {
            it.next();
        }
        it.remove();
        return t;
    }

    @Override
    public boolean removeAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AbstractEntryBinding> iteratorReference() {
        return new ReferenceIterator();
    }

    public class ReferenceIterator
    extends AbstractIterator<AbstractEntryBinding> {
        @Override
        public AbstractEntryBinding next() {
            this.advance();
            AttributeBinding att = (AttributeBinding)ValueListBinding.this.attribute;
            return new EntryBinding(ValueListBinding.this.attribute.getReferencedRelation(), att.intData.get(this.currentIdx));
        }
    }

    public class ValueListBindingIterator
    extends GenericIterator<T> {
    }

    public class GenericIterator<E>
    extends AbstractIterator<E> {
        @Override
        public E next() {
            this.advance();
            AttributeBinding att = (AttributeBinding)ValueListBinding.this.attribute;
            switch (ValueListBinding.this.attribute.getType()) {
                case INTEGER: 
                case REFERENCE: {
                    return (E)Integer.valueOf(att.intData.get(this.currentIdx));
                }
                case FLOAT: {
                    return (E)Float.valueOf(att.floatData.get(this.currentIdx));
                }
                case STRING: {
                    return (E)att.stringData.get(this.currentIdx);
                }
                case BOOLEAN: {
                    byte v = att.boolData.get(this.currentIdx);
                    if (v == 1) {
                        return (E)Boolean.TRUE;
                    }
                    return (E)Boolean.FALSE;
                }
            }
            throw new AssertionError();
        }
    }

    private abstract class AbstractIterator<E>
    implements Iterator<E> {
        protected int currentIdx = -1;
        protected int nextIdx;

        protected AbstractIterator() {
            this.nextIdx = ((ValueListBinding)ValueListBinding.this).ab.listStarts.get(ValueListBinding.this.entryOffset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx != -1;
        }

        protected void advance() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentIdx = this.nextIdx;
            this.nextIdx = ((AttributeBinding)((ValueListBinding)ValueListBinding.this).attribute).nextIndex.get(this.currentIdx);
        }

        @Override
        public void remove() {
            AttributeBinding ab = (AttributeBinding)ValueListBinding.this.attribute;
            if (this.currentIdx == ab.listStarts.get(ValueListBinding.this.entryOffset)) {
                ab.listStarts.set(ValueListBinding.this.entryOffset, ab.nextIndex.get(this.currentIdx));
            } else if (this.currentIdx == ab.listEnds.get(ValueListBinding.this.entryOffset)) {
                for (int lookupIdx = this.currentIdx; lookupIdx >= 0; --lookupIdx) {
                    if (ab.nextIndex.get(lookupIdx) != this.currentIdx) continue;
                    ab.listEnds.set(ValueListBinding.this.entryOffset, lookupIdx);
                    ab.nextIndex.set(lookupIdx, -1);
                    break;
                }
            } else {
                for (int lookupIdx = this.currentIdx; lookupIdx >= 0; --lookupIdx) {
                    if (ab.nextIndex.get(lookupIdx) != this.currentIdx) continue;
                    ab.nextIndex.set(lookupIdx, ab.nextIndex.get(this.currentIdx));
                    break;
                }
            }
            ab.nextIndex.set(this.currentIdx, -1);
        }
    }
}

