/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.tree.BTree;
import de.uni_bremen.st.rcf.persistence.bplus.tree.DataType;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AttributeBinding
extends AbstractAttributeBinding {
    private static final int kNodeCapacity = 4;
    int attributeId;
    private String attributeName;
    private AttributeType type;
    private boolean isList;
    private boolean isEnum;
    private List<String> enumValues;
    private String referencedRelationName;
    BTree btree;

    protected AttributeBinding(String name, AttributeType type, int attributeId, boolean isList, boolean isEnum, List<String> enumValues, RelationBinding relation, String referencedRelationName) throws IOException {
        super(name, relation);
        this.attributeId = attributeId;
        this.attributeName = name;
        this.type = type;
        this.isList = isList;
        this.isEnum = isEnum;
        this.enumValues = enumValues;
        this.referencedRelationName = referencedRelationName;
        File treefile = relation.schema.getTreeFile(relation.getName(), name);
        DataType dtype = DataType.fromAttributeType(type);
        if (isList) {
            dtype = DataType.LONG;
        }
        if (treefile.exists()) {
            this.btree = BTree.load(treefile);
            if (this.btree.getValueType() != dtype) {
                throw new IOException("The value type of the tree backing this attribute does not match the type you specified.");
            }
        } else {
            this.btree = BTree.create(treefile, dtype, 4);
        }
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public AbstractRelationBinding getReferencedRelation() {
        if (this.referencedRelationName == null) {
            return null;
        }
        return this.relation.getRcf().getRelation(this.referencedRelationName);
    }

    boolean isIdAttribute() {
        return this.attributeId == 0;
    }

    int getLargestKey() throws IOException {
        return this.btree.largestKey();
    }
}

