/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.Schema;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RCFBinding
extends AbstractRCFBinding {
    final File file;
    final Schema schema;
    private Map<String, RelationBinding> relationBindingRefs = new HashMap<String, RelationBinding>();
    private Collection<String> relations = null;
    private Map<String, Collection<String>> attributes = null;
    private Map<String, AttributeType> types = null;

    public RCFBinding(File file) throws IOException {
        this.file = file;
        File schemaFile = new File(file, "schema");
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create rcf directory.");
        }
        this.schema = new Schema();
        if (schemaFile.exists()) {
            this.schema.load(schemaFile);
        } else {
            this.schema.store(schemaFile);
        }
        this.readSchema();
    }

    private void readSchema() {
        this.relations = this.schema.getRelations();
        this.attributes = new HashMap<String, Collection<String>>(this.relations.size());
        for (String r : this.relations) {
            List<String> relationAttributes = this.schema.getAttributes(r);
            this.attributes.put(r, this.schema.getAttributes(r));
            for (String a : relationAttributes) {
                AttributeType type = this.schema.getAttributeType(r, a);
                String fqname = r + "/" + a;
                this.types.put(fqname, type);
            }
        }
    }

    @Override
    public AbstractRelationBinding addRelation(String name) {
        RelationBinding binding;
        this.schema.addRelation(name);
        try {
            binding = new RelationBinding(this, name, null);
        }
        catch (IOException e) {
            throw new RuntimeException("An I/O error occurred.", e);
        }
        this.relationBindingRefs.put(name, binding);
        return binding;
    }

    @Override
    public AbstractRelationBinding getRelation(String name) {
        RelationBinding binding = this.relationBindingRefs.get(name);
        if (binding == null) {
            List<String> attributeNames = this.schema.getAttributes(name);
            try {
                binding = new RelationBinding(this, name, attributeNames);
                this.relationBindingRefs.put(name, binding);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return binding;
    }

    @Override
    public List<AbstractRelationBinding> getRelations() {
        assert (this.relations != null);
        ArrayList<AbstractRelationBinding> bindings = new ArrayList<AbstractRelationBinding>(this.relations.size());
        for (String r : this.relations) {
            bindings.add(this.getRelation(r));
        }
        return bindings;
    }

    @Override
    public boolean hasRelation(String name) {
        assert (this.relations != null);
        return this.relations.contains(name);
    }

    @Override
    public void save() {
        try {
            this.schema.store();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store schema.", e);
        }
    }

    @Override
    public void saveAs(File f) {
        throw new UnsupportedOperationException("Create a new RCF and copy all contents.");
    }

    @Override
    public void close() {
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

