/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationIteratorBinding;
import de.uni_bremen.st.rcf.persistence.bplus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bplus.EmptyTreeException;
import de.uni_bremen.st.rcf.persistence.bplus.EntryBinding;
import de.uni_bremen.st.rcf.persistence.bplus.RCFBinding;
import de.uni_bremen.st.rcf.persistence.bplus.RelationIteratorBinding;
import de.uni_bremen.st.rcf.persistence.bplus.Schema;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.BlobStore;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationBinding
extends AbstractRelationBinding {
    protected Map<String, AttributeBinding> attributes;
    private int nextId;
    private int nextAttributeId;
    protected Schema schema;
    protected BlobStore blobs;

    public RelationBinding(RCFBinding rcf, String name, List<String> attributeNames) throws IOException {
        super(rcf, name);
        this.schema = rcf.schema;
        this.nextId = 0;
        if (attributeNames == null) {
            this.nextAttributeId = 0;
            this.attributes = new HashMap<String, AttributeBinding>();
            this.attributes.put("id", this.createIdAttribute());
        } else {
            this.nextAttributeId = attributeNames.size();
            this.attributes = new HashMap<String, AttributeBinding>(this.nextAttributeId);
            for (String aname : attributeNames) {
                this.attributes.put(aname, this.createAttributeBinding(aname, rcf));
            }
        }
        File file = this.schema.getBlobFile(name);
        this.blobs = new BlobStore(file);
        AttributeBinding idAttribute = this.attributes.get("id");
        try {
            this.nextId = idAttribute.getLargestKey() + 1;
        }
        catch (EmptyTreeException e) {
            this.nextId = 0;
        }
    }

    private AttributeBinding createIdAttribute() throws IOException {
        assert (this.nextAttributeId == 0);
        this.schema.addAttribute(this.name, "id", false, false, null, AttributeType.INTEGER, null);
        AttributeBinding idbinding = new AttributeBinding("id", AttributeType.INTEGER, this.nextAttributeId, false, false, null, this, null);
        this.attributes.put("id", idbinding);
        ++this.nextAttributeId;
        return idbinding;
    }

    private AttributeBinding createAttributeBinding(String aname, RCFBinding rcf) throws IOException {
        AttributeType type = this.schema.getAttributeType(this.name, aname);
        boolean isList = this.schema.isList(this.name, aname);
        boolean isEnum = this.schema.isEnum(this.name, aname);
        List<String> enumValues = this.schema.getEnumValues(this.name, aname);
        String refRelName = this.schema.getReferencedRelationName(this.name, aname);
        int attributeId = this.nextAttributeId++;
        AttributeBinding binding = new AttributeBinding(aname, type, attributeId, isList, isEnum, enumValues, this, refRelName);
        return binding;
    }

    @Override
    public AbstractEntryBinding getEntry(int id) {
        return new EntryBinding(this, id);
    }

    @Override
    public AbstractEntryBinding createEntry() {
        AttributeBinding idAttribute = this.attributes.get("id");
        int newid = this.nextId++;
        try {
            idAttribute.btree.put(newid, 1);
        }
        catch (IOException e) {
            throw new RuntimeException("An I/O error occurred.", e);
        }
        return new EntryBinding(this, newid);
    }

    @Override
    public void deleteEntry(int id) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public AbstractAttributeBinding getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public List<AbstractAttributeBinding> getAttributes() {
        ArrayList<AbstractAttributeBinding> bindings = new ArrayList<AbstractAttributeBinding>(this.attributes.size());
        bindings.addAll(this.attributes.values());
        return bindings;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public AbstractAttributeBinding addAttribute(String name, AttributeType type, boolean isList, boolean isEnum, AbstractRelationBinding referencedRelation, String ... enumValues) {
        AttributeBinding attribute;
        try {
            int attributeId = this.nextAttributeId++;
            List<String> enumList = Arrays.asList(enumValues);
            String refRelName = referencedRelation == null ? null : referencedRelation.getName();
            this.schema.addAttribute(this.name, name, isList, isEnum, enumList, type, refRelName);
            attribute = new AttributeBinding(name, type, attributeId, isList, isEnum, enumList, this, refRelName);
            this.attributes.put(name, attribute);
        }
        catch (IOException e) {
            throw new RuntimeException("An I/O error occurred.", e);
        }
        return attribute;
    }

    @Override
    public int size() {
        AttributeBinding id = (AttributeBinding)this.getAttribute("id");
        try {
            return id.btree.largestKey() + 1;
        }
        catch (IOException e) {
            throw new RuntimeException("An I/O error occurred.");
        }
    }

    @Override
    public AbstractRelationIteratorBinding iterator() {
        try {
            return new RelationIteratorBinding(this);
        }
        catch (IOException e) {
            throw new RuntimeException("An I/O error occurred.");
        }
    }
}

