/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationIteratorBinding;
import de.uni_bremen.st.rcf.persistence.bplus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bplus.EntryBinding;
import de.uni_bremen.st.rcf.persistence.bplus.tree.Leaf;
import java.io.IOException;

public class RelationIteratorBinding
extends AbstractRelationIteratorBinding {
    private AttributeBinding idAttributeBinding;
    private Leaf leaf;
    private int nextIndex;
    private long successor;

    public RelationIteratorBinding(AbstractRelationBinding relation) throws IOException {
        super(relation);
        this.idAttributeBinding = (AttributeBinding)relation.getAttribute("id");
        this.leaf = this.idAttributeBinding.btree.leftmostLeaf();
        this.nextIndex = 0;
        this.successor = this.leaf.getSuccessor();
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.leaf.getNumUsed() || this.successor != -1L;
    }

    @Override
    public AbstractEntryBinding next() {
        if (!this.hasNext()) {
            throw new RuntimeException("No more elements.");
        }
        if (this.nextIndex >= this.leaf.getNumUsed()) {
            try {
                this.leaf = (Leaf)this.idAttributeBinding.btree.loadNode(this.successor);
                this.successor = this.leaf.getSuccessor();
                this.nextIndex = 0;
            }
            catch (IOException e) {
                throw new RuntimeException("An I/O error occurred.", e);
            }
        }
        int key = this.leaf.getKeyAt(this.nextIndex++);
        return new EntryBinding(this.relation, key);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("TODO: Implemented removing.");
    }
}

