/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.exceptions.AttributeExistsException;
import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.exceptions.NoSuchRelationException;
import de.uni_bremen.st.rcf.exceptions.RelationExistsException;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class Schema {
    private static final String kBlobFileSuffix = ".blob";
    private static final String kTreeFileSuffix = ".index";
    public static final String kSeparator = "/";
    private static final String kListDelimiter = ":";
    private static final String kRelationsKey = "relations";
    private static final String kAttributesKey = "attributes";
    private Properties properties = new Properties();
    private File schemaFile = null;

    public void load(File schemaFile) throws IOException {
        this.schemaFile = schemaFile;
        FileInputStream fis = new FileInputStream(schemaFile);
        this.properties.load(fis);
        fis.close();
    }

    public void store(File schemaFile) throws IOException {
        this.schemaFile = schemaFile;
        FileOutputStream fos = new FileOutputStream(schemaFile, false);
        this.properties.store(fos, "Indexed RCF schema.");
        fos.close();
    }

    public void store() throws IOException {
        if (this.schemaFile == null) {
            throw new NullPointerException("No schema file set. Perhaps you did not load the schema from a file.");
        }
        this.store(this.schemaFile);
    }

    public boolean hasRelation(String relation) {
        String[] relationa;
        String relations = this.properties.getProperty(kRelationsKey);
        if (relations == null) {
            return false;
        }
        for (String r : relationa = relations.split(kListDelimiter)) {
            if (!relation.equals(r)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getRelations() {
        List<String> relationsList;
        String relations = this.properties.getProperty(kRelationsKey);
        if (relations == null) {
            relationsList = new LinkedList<String>();
        } else {
            String[] relationsa = relations.split(kListDelimiter);
            relationsList = Arrays.asList(relationsa);
        }
        return relationsList;
    }

    public boolean hasAttribute(String relation, String attribute) {
        String[] attributa;
        if (!this.hasRelation(relation)) {
            throw new NoSuchRelationException();
        }
        String relationAttributesKey = relation + kSeparator + kAttributesKey;
        String attributes = this.properties.getProperty(relationAttributesKey);
        if (attributes == null) {
            return false;
        }
        for (String a : attributa = attributes.split(kListDelimiter)) {
            if (!attribute.equals(a)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAttributes(String relation) {
        List<String> attributesList;
        if (!this.hasRelation(relation)) {
            throw new NoSuchRelationException();
        }
        String relationAttributesKey = relation + kSeparator + kAttributesKey;
        String attributes = this.properties.getProperty(relationAttributesKey);
        if (attributes == null) {
            attributesList = new LinkedList<String>();
        } else {
            String[] attributea = attributes.split(kListDelimiter);
            attributesList = Arrays.asList(attributea);
        }
        return attributesList;
    }

    private boolean getBoolean(String relation, String attribute, String booleanProperty) {
        if (!this.hasAttribute(relation, attribute)) {
            throw new NoSuchAttributeException();
        }
        String key = relation + kSeparator + attribute + kSeparator + booleanProperty;
        String isList = this.properties.getProperty(key);
        return Boolean.parseBoolean(isList);
    }

    public boolean isList(String relation, String attribute) {
        return this.getBoolean(relation, attribute, "isList");
    }

    public boolean isEnum(String relation, String attribute) {
        return this.getBoolean(relation, attribute, "isEnum");
    }

    public AttributeType getAttributeType(String relation, String attribute) {
        if (!this.hasAttribute(relation, attribute)) {
            throw new NoSuchAttributeException();
        }
        String key = relation + kSeparator + attribute + kSeparator + "type";
        String typeString = this.properties.getProperty(key);
        return AttributeType.valueOf(typeString);
    }

    public String getReferencedRelationName(String relation, String attribute) {
        if (!this.hasAttribute(relation, attribute)) {
            throw new NoSuchAttributeException();
        }
        String key = relation + kSeparator + attribute + kSeparator + "referencedRelationName";
        return this.properties.getProperty(key);
    }

    public List<String> getEnumValues(String relation, String attribute) {
        List<String> enumValuesList;
        if (!this.hasAttribute(relation, attribute)) {
            throw new NoSuchAttributeException();
        }
        String key = relation + kSeparator + attribute + kSeparator + "enumValues";
        String enumValues = this.properties.getProperty(key);
        if (enumValues == null) {
            enumValuesList = new LinkedList<String>();
        } else {
            String[] enumValuea = enumValues.split(kListDelimiter);
            enumValuesList = Arrays.asList(enumValuea);
        }
        return enumValuesList;
    }

    public File getBlobFile(String relation) {
        if (!this.hasRelation(relation)) {
            throw new NoSuchRelationException();
        }
        File parent = this.schemaFile.getAbsoluteFile().getParentFile();
        String blobPath = relation + kBlobFileSuffix;
        File blobFile = new File(parent, blobPath);
        return blobFile;
    }

    public File getTreeFile(String relation, String attribute) {
        if (!this.hasAttribute(relation, attribute)) {
            throw new NoSuchAttributeException();
        }
        File parent = this.schemaFile.getAbsoluteFile().getParentFile();
        String treePath = relation + File.pathSeparator + attribute + kTreeFileSuffix;
        File treeFile = new File(parent, treePath);
        return treeFile;
    }

    public void addRelation(String relation) {
        String[] relationa;
        String relations = this.properties.getProperty(kRelationsKey);
        if (relations == null) {
            this.properties.setProperty(kRelationsKey, relation + kListDelimiter);
            return;
        }
        for (String r : relationa = relations.split(kListDelimiter)) {
            if (!relation.equals(r)) continue;
            throw new RelationExistsException();
        }
        this.properties.setProperty(kRelationsKey, relations + relation + kListDelimiter);
    }

    public void addAttribute(String relation, String attribute, boolean isList, boolean isEnum, List<String> enumValues, AttributeType type, String referencedRelationName) {
        String relationAttributesKey = relation + kSeparator + kAttributesKey;
        String attributes = this.properties.getProperty(relationAttributesKey);
        if (attributes == null) {
            this.properties.setProperty(relationAttributesKey, attribute + kListDelimiter);
        } else {
            String[] attributea;
            for (String a : attributea = attributes.split(kListDelimiter)) {
                if (!attribute.equals(a)) continue;
                throw new AttributeExistsException();
            }
            this.properties.setProperty(relationAttributesKey, attributes + attribute + kListDelimiter);
        }
        String fqAttributeName = relation + kSeparator + attribute;
        String isListProperty = fqAttributeName + kSeparator + "isList";
        String isEnumProperty = fqAttributeName + kSeparator + "isEnum";
        this.properties.setProperty(isListProperty, Boolean.valueOf(isList).toString());
        this.properties.setProperty(isEnumProperty, Boolean.valueOf(isEnum).toString());
        if (isEnum) {
            String enumValuesProperty = fqAttributeName + kSeparator + "enumValues";
            StringBuilder enumValuesString = new StringBuilder();
            for (String ev : enumValues) {
                enumValuesString.append(ev);
                enumValuesString.append(kListDelimiter);
            }
            this.properties.setProperty(enumValuesProperty, enumValuesString.toString());
        }
        String typeProperty = fqAttributeName + kSeparator + "type";
        this.properties.setProperty(typeProperty, type.toString());
        if (type == AttributeType.REFERENCE) {
            String referencedRelationProperty = fqAttributeName + kSeparator + "referencedRelationName";
            this.properties.setProperty(referencedRelationProperty, referencedRelationName);
        }
    }

    public void list(PrintStream out) {
        this.properties.list(out);
    }

    public void list() {
        this.list(System.out);
    }
}

