/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus;

import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.bplus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bplus.ElementNotFoundException;
import de.uni_bremen.st.rcf.persistence.bplus.EntryBinding;
import de.uni_bremen.st.rcf.persistence.bplus.RelationBinding;
import de.uni_bremen.st.rcf.persistence.bplus.ValueListBindingIterator;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.AbstractChunk;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.BlobStore;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ValueListBinding<T>
extends AbstractValueListBinding<T> {
    static final int kChunkSize = 5;
    protected AbstractChunk currentChunk = null;
    protected long currentChunkPosition = 0L;

    protected void loadFirstChunk() throws IOException, ElementNotFoundException {
        if (this.currentChunk != null && this.currentChunk.getPredecessor() == -1L) {
            return;
        }
        AttributeBinding attribute = (AttributeBinding)this.attribute;
        RelationBinding relation = (RelationBinding)attribute.getRelation();
        if (this.currentChunk != null) {
            relation.blobs.writeChunk(this.currentChunk, this.currentChunkPosition);
        } else {
            this.currentChunk = this.createChunk();
        }
        this.currentChunkPosition = attribute.btree.getLong(this.entry.getId());
        relation.blobs.readChunk(this.currentChunk, this.currentChunkPosition);
    }

    protected void loadChunk(long position) throws IOException {
        if (position == this.currentChunkPosition) {
            return;
        }
        BlobStore bs = ((RelationBinding)this.attribute.getRelation()).blobs;
        if (this.currentChunk != null) {
            bs.writeChunk(this.currentChunk, this.currentChunkPosition);
        } else {
            this.currentChunk = this.createChunk();
        }
        bs.readChunk(this.currentChunk, position);
        this.currentChunkPosition = position;
    }

    protected void searchToEndOfList() throws IOException, ElementNotFoundException {
        if (this.currentChunk == null) {
            this.loadFirstChunk();
        }
        while (this.currentChunk.getSuccessor() != -1L) {
            this.loadChunk(this.currentChunk.getSuccessor());
        }
    }

    protected abstract void addValueToChunk(AbstractChunk var1, int var2, T var3);

    public ValueListBinding(AbstractAttributeBinding aattribute, AbstractEntryBinding aentry) throws IOException, ElementNotFoundException {
        super(aattribute, aentry);
        if (!aentry.isSet(aattribute)) {
            EntryBinding eb = (EntryBinding)aentry;
            AttributeBinding ab = (AttributeBinding)aattribute;
            BlobStore bs = ((RelationBinding)ab.getRelation()).blobs;
            this.currentChunk = this.createChunk();
            this.currentChunkPosition = bs.appendBlob(this.currentChunk);
            ab.btree.put(eb.getId(), this.currentChunkPosition);
        }
    }

    @Override
    public boolean add(T value) {
        try {
            this.searchToEndOfList();
            if (this.currentChunk.numUsed < 5) {
                this.addValueToChunk(this.currentChunk, this.currentChunk.numUsed, value);
            } else {
                BlobStore bs = ((RelationBinding)this.attribute.getRelation()).blobs;
                AbstractChunk chunk = this.createChunk();
                this.addValueToChunk(chunk, 0, value);
                chunk.numUsed = 1;
                chunk.setPredecessor(this.currentChunkPosition);
                long chunkPos = bs.appendBlob(chunk);
                this.currentChunk.setSuccessor(chunkPos);
            }
            return true;
        }
        catch (IOException e1) {
            this.ioerror(e1);
        }
        catch (ElementNotFoundException e1) {
            this.notFound(e1);
        }
        return false;
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this) {
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    protected T getValueFromCurrentChunk(int index) {
        return this.getValueFromChunk(this.currentChunk, index);
    }

    protected abstract T getValueFromChunk(AbstractChunk var1, int var2);

    @Override
    public T get(int index) {
        int chunkNo = index / 5;
        try {
            this.loadFirstChunk();
            for (int i = 0; i < chunkNo; ++i) {
                this.loadChunk(this.currentChunk.getSuccessor());
            }
            int chunkIndex = index - chunkNo * 5;
            return this.getValueFromCurrentChunk(chunkIndex);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return null;
    }

    @Override
    public int indexOf(Object arg0) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public boolean isEmpty() {
        try {
            this.loadFirstChunk();
            return this.currentChunk.isEmpty();
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            this.loadFirstChunk();
            BlobStore bs = ((RelationBinding)this.attribute.getRelation()).blobs;
            return new ValueListBindingIterator(this, this.currentChunk, this.currentChunkPosition, bs);
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return null;
    }

    @Override
    public Iterator<AbstractEntryBinding> iteratorReference() {
        throw new RuntimeException("This is not a reference attribute.");
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int arg0) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int arg0, T arg1) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public int size() {
        int size = 0;
        try {
            this.loadFirstChunk();
            while (true) {
                size += this.currentChunk.size();
                long successor = this.currentChunk.getSuccessor();
                if (successor != -1L) {
                    this.loadChunk(successor);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.ioerror(e);
        }
        catch (ElementNotFoundException e) {
            this.notFound(e);
        }
        return size;
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public <U> U[] toArray(U[] arg0) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public AbstractEntryBinding getReference(int index) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public AbstractEntryBinding setReference(int index, AbstractEntryBinding entry) {
        throw new RuntimeException("TODO Implement me!");
    }

    @Override
    public boolean addReference(AbstractEntryBinding binding) {
        throw new RuntimeException("This is not a reference attribute.");
    }

    @Override
    public void addReference(int index, AbstractEntryBinding binding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllReference(int index, List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsReference(AbstractEntryBinding entryBinding) {
        throw new RuntimeException("This is not a reference attribute.");
    }

    @Override
    public boolean containsAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOfReference(AbstractEntryBinding entryBinding) {
        throw new RuntimeException("This is not a reference attribute.");
    }

    @Override
    public int lastIndexOfReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractEntryBinding removeReferece(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractEntryBinding> subListReference(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    protected void ioerror(IOException e) {
        throw new RuntimeException("An I/O error occurred.", e);
    }

    protected void notFound(ElementNotFoundException e) {
        throw new RuntimeException("Could not find the entry.", e);
    }

    protected abstract AbstractChunk createChunk();
}

