/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bplus.blobs;

import de.uni_bremen.st.rcf.persistence.bplus.blobs.Blob;
import de.uni_bremen.st.rcf.persistence.bplus.blobs.Chunk;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractChunk
implements Blob,
Chunk {
    long predecessor = -1L;
    long successor = -1L;
    public int numUsed = 0;

    public AbstractChunk(int numValues) {
    }

    @Override
    public long getSuccessor() {
        return this.successor;
    }

    @Override
    public long getPredecessor() {
        return this.predecessor;
    }

    @Override
    public void setSuccessor(long successor) {
        this.successor = successor;
    }

    @Override
    public void setPredecessor(long predecessor) {
        this.predecessor = predecessor;
    }

    protected abstract int valuesArraySize();

    @Override
    public int sizeBytes() {
        int size = 8;
        size += 8;
        size += this.valuesArraySize();
        return size += 4;
    }

    protected abstract void writeValuesArray(ByteBuffer var1) throws IOException;

    @Override
    public void writeToByteBuffer(ByteBuffer buffer) throws IOException {
        buffer.putLong(this.predecessor);
        buffer.putLong(this.successor);
        this.writeValuesArray(buffer);
        buffer.putInt(this.numUsed);
    }

    protected abstract void readValuesArray(ByteBuffer var1) throws IOException;

    @Override
    public void readFromByteBuffer(ByteBuffer buffer) throws IOException {
        this.predecessor = buffer.getLong();
        this.successor = buffer.getLong();
        this.readValuesArray(buffer);
        this.numUsed = buffer.getInt();
    }

    @Override
    public void set(int index, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.numUsed;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

